% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_from_model.R
\name{.get_data_from_model}
\alias{.get_data_from_model}
\title{(Internal) Locate data in call stack}
\usage{
.get_data_from_model(which_fn, form = NULL, by = NULL)
}
\arguments{
\item{which_fn}{Identify calling function, "weights" or "assigned", helps
separate logic for the two functions.}

\item{form}{Formula on which to apply \code{model.frame()}. See details}

\item{by}{translation of unit of assignment/unitid/cluster ID names, passed
down from weights.}
}
\value{
\code{data.frame}
}
\description{
Whenever a function in a model
(\code{ate()}/\code{ett()}/\code{cov_adj()}/\code{assigned()}) is called
without an explicit \code{data=} argument, this will attempt to extract the
data from the model itself.
}
\details{
The \code{form} specifies what columns of the data are needed. For current
use cases (\code{ate()}/\code{ett()} and \code{assigned()}), this will be
only the unit of assignment variables, so e.g. \code{form = ~ uoavar}, to
enable merging of UOA level variables to the model data. However, this can
easily be expanded if other variables are needed.
}
\keyword{internal}
