% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-extras.R
\name{GetSitelevelSummaries}
\alias{GetSitelevelSummaries}
\title{Get the PREDICTS database site level summaries.}
\usage{
GetSitelevelSummaries(extract = c(2016, 2022))
}
\arguments{
\item{extract}{Numeric, year/s corresponding to PREDICTS database releases to
download. Options are 2016 or 2022. Defaults to \code{c(2016, 2022)} - the whole
dataset.}
}
\value{
The site-level summary data as a dataframe.
}
\description{
This acesses summary data for the relevant PREDICTS database extract.
}
\details{
The PREDICTS database contains site-level summaries of the data collected
as part of the PREDICTS project - Projecting Responses of Ecological
Diversity In Changing Terrestrial Systems.

The site-level summaries are provided as a dataframe, with each row
corresponding to a site-level observation, and each column corresponding to
a variable describing the site or the observation. The data are provided in
a standardised format, with column names that are consistent across the
database.

There are two releases of the PREDICTS database, an initial release in 2016,
and an additional release in 2022. The user chooses whether to pull summary
data for the 2016 and/or 2022 release.

The data are provided under a CC NC (non-commercial) license, which means
that they cannot be used for commercial purposes. The 2016 release is
available under a CC BY-NC-SA 4.0 license, and the 2022 release is
available under a CC NC (any) license.
}
\examples{
\donttest{
  summaries <- GetSitelevelSummaries()
  summaries_2016 <- GetSitelevelSummaries(extract = 2016)
}

}
