% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate.r
\name{posterior_univariate}
\alias{posterior_univariate}
\title{Posterior Obtained by Updating Power Prior with Current Data (Univariate)}
\usage{
posterior_univariate(powerprior, current_data)
}
\arguments{
\item{powerprior}{Object of class "powerprior_univariate" from powerprior_univariate()}

\item{current_data}{Numeric vector of current trial observations. Must contain
at least 2 observations. Missing values (NAs) are automatically removed.}
}
\value{
A list of class "posterior_univariate" containing:
\item{mu_star}{Posterior mean parameter}
\item{kappa_star}{Posterior precision parameter}
\item{nu_star}{Posterior degrees of freedom}
\item{sigma2_star}{Posterior scale parameter}
\item{n}{Sample size of current data}
\item{ybar}{Sample mean of current data}
\item{Sy}{Sum of squared deviations of current data}
\item{powerprior}{Original power prior object}
}
\description{
Updates a power prior with current trial data to obtain the posterior
distribution.
}
\details{
\subsection{Posterior Updating}{

Given a power prior distribution P(\eqn{\mu}, \eqn{\sigma^2} | x, \eqn{a_0}) and new current data y,
the posterior distribution is computed by combining the power prior with
the likelihood of the current data using Bayes' theorem.

The conjugate structure ensures the posterior remains a NIX distribution.
For both informative and vague initial priors, the updating follows standard
conjugate rules, leveraging the fact that both the power prior and likelihood
are in the NIX family.

This eliminates the computational burden of MCMC and allows direct posterior
inference and sampling (see \code{\link{sample_posterior_univariate}}).
}
}
\examples{
# Generate data
historical <- rnorm(50, mean = 10, sd = 2)
current <- rnorm(30, mean = 10.5, sd = 2)

# Compute power prior and posterior
pp <- powerprior_univariate(historical, a0 = 0.5)
posterior <- posterior_univariate(pp, current)
print(posterior)

# With informative prior
pp_inform <- powerprior_univariate(
  historical, a0 = 0.5,
  mu0 = 10, kappa0 = 1, nu0 = 3, sigma2_0 = 4
)
posterior_inform <- posterior_univariate(pp_inform, current)
print(posterior_inform)

}
