% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{bayes_factor}
\alias{bayes_factor}
\title{Calculate Bayes Factor}
\usage{
bayes_factor(
  historical_data,
  current_data,
  a0_1,
  a0_2 = 0,
  multivariate = FALSE,
  ...
)
}
\arguments{
\item{historical_data}{Historical data}

\item{current_data}{Current data}

\item{a0_1}{First discounting parameter}

\item{a0_2}{Second discounting parameter (default: 0)}

\item{multivariate}{Logical indicating multivariate data (default: FALSE)}

\item{...}{Additional arguments passed to powerprior functions}
}
\value{
Bayes factor (BF_12 = P(data|a0_1) / P(data|a0_2))
}
\description{
Computes the Bayes factor comparing two models with different discounting parameters.
}
\details{
The Bayes factor compares the marginal likelihoods under two different
discounting parameters. BF > 1 favors a0_1, BF < 1 favors a0_2.

Note: This is a simple approximation using the observed data likelihood
evaluated at posterior means.
}
\examples{
set.seed(123)
historical <- rnorm(50, mean = 10, sd = 2)
current <- rnorm(30, mean = 10.5, sd = 2)

# Compare moderate borrowing (0.5) vs no borrowing (0)
bf <- bayes_factor(historical, current, a0_1 = 0.5, a0_2 = 0)
cat("Bayes Factor:", bf, "\n")

}
