% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_funcs.R
\name{mean_center}
\alias{mean_center}
\title{Mean Center Transformation}
\usage{
mean_center(
  e_data,
  edata_id,
  subset_fn,
  feature_subset,
  backtransform = FALSE,
  apply_norm = FALSE,
  check.names = NULL
)
}
\arguments{
\item{e_data}{e_data a \eqn{p \times n + 1} data.frame, where \eqn{p} is the
number of peptides, lipids, or metabolites and \eqn{n} is the number of
samples. Each row corresponds to data for a peptide, protein, lipid, or
metabolite, with one column giving the biomolecule identifier name.}

\item{edata_id}{character string indicating the name of the peptide, protein,
lipid, or metabolite identifier. Usually obtained by calling
\code{attr(omicsData, "cnames")$edata_cname}.}

\item{subset_fn}{character string indicating the subset function to use for
normalization.}

\item{feature_subset}{character vector containing the feature names in the
subset to be used for normalization}

\item{backtransform}{logical argument. If TRUE, the data will be back
transformed after normalization so that the values are on a scale similar
to their raw values. See details for more information. Defaults to FALSE.}

\item{apply_norm}{logical argument. If TRUE, the normalization will be
applied to the data. Defaults to FALSE.}

\item{check.names}{deprecated}
}
\value{
List containing two elements: \code{norm_params} is list with two
  elements:
\tabular{ll}{
scale \tab NULL \cr
\tab \cr
location \tab numeric vector of length \code{n} means for each sample
\cr
}

\code{backtransform_params} is a list with two elements:
\tabular{ll}{
scale \tab NULL \cr
\tab \cr
location \tab numeric value giving global median across all samples
\cr
}
If \code{backtransform} is set to TRUE then each list item under
\code{backtransform_params} will be NULL.

If \code{apply_norm} is TRUE, the transformed data is returned as a third
list item.
}
\description{
Calculate normalization parameters for the data via via mean centering.
}
\details{
The sample-wise mean of the feature subset specified for
  normalization is subtracted from each feature in e_data to get the
  normalized data. The location estimates are the sample-wise means of the
  subset data. There are no scale estimates for mean centering, though the
  function returns a NULL list element as a placeholdfer for a scale
  estimate. If backtransform is TRUE, the global median of the subset data
  (across all samples) is added back to the normalized values. Medians are
  taken ignoring any NA values.
}
\author{
Lisa Bramer, Kelly Stratton
}
