% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{get_opts}
\alias{get_opts}
\alias{all_opts}
\title{Retrieve options for creating a plumber2 api}
\usage{
get_opts(x, default = NULL)

all_opts()
}
\arguments{
\item{x}{The name of the option}

\item{default}{The default value, if \code{x} is not set}
}
\value{
For \code{get_opts} The value of \code{x}, if any, or \code{default}. For
\code{all_opts()} a named list of all the options that are set
}
\description{
You can provide options for your plumber2 api which will be picked up when
you create the API with \code{\link[=api]{api()}}. Options can be set either through the
internal \code{\link[=options]{options()}} functionality, or by setting environment variables. In
the former case, the name of the option must be prefixed with \code{"plumber2."},
in the latter case the variable name must be in upper case and prefixed with
\code{"PLUMBER2_"}. If the option is stored as an environment variable then the
value is cast to the type giving in \code{default}. See the docs for \code{\link[=api]{api()}} for
the default values of the different options.
}
\section{plumber2 options}{
The following options are currently recognized by plumber2. They are all read
at creation time and have a parallel argument in \code{\link[=api]{api()}} where you can also
see their default values. This means that changing an option after
creation/during running will have no effect.
\itemize{
\item \strong{host}: The address to serve the server from
\item \strong{port}: The port to use for the server
\item \strong{docType}: The ui to use for serving OpenAPI documentation
\item \strong{docPath}: The path to serve the documentation from
\item \strong{rejectMissingMethods}: Should requests to paths that doesn't have a
handler for the specific method automatically be rejected with a 405 Method
Not Allowed response
\item \strong{ignoreTrailingSlash}: Should the trailing slash of a path be ignored
when adding handlers and handling requests
\item \strong{maxRequestSize}: The maximum allowed size of request bodies
\item \strong{sharedSecret}: A shared secret the request must contain to be permitted
\item \strong{compressionLimit}: The threshold for response size before automatic
compression is used
\item \strong{async}: The default async engine to use
}
}

\examples{
# Using `options()`
old_opts <- options(plumber2.port = 9889L)
get_opts("port")
options(old_opts)

# Using environment variables
old_env <- Sys.getenv("PLUMBER2_PORT")
Sys.setenv(PLUMBER2_PORT = 9889)

## If no default is provided the return value is a string
get_opts("port")

## Provide a default to hint at the options type
get_opts("port", 8080L)

Sys.setenv(PLUMBER2_PORT = old_env)

}
