% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_auth.R
\name{api_auth_guard}
\alias{api_auth_guard}
\title{Add an auth guard to your API}
\usage{
api_auth_guard(api, guard, name = NULL)
}
\arguments{
\item{api}{A plumber2 api object to add the authenticator to}

\item{guard}{A \link[fireproof:Guard]{Guard} subclass object defining an
authentication scheme}

\item{name}{The name to use for referencing the guard in an authentication
flow}
}
\value{
This functions return the \code{api} object allowing for easy chaining
with the pipe
}
\description{
This function adds an auth guard to your API. Notably, this does
not turn on auth for any of your handlers but makes it available
for reference in an auth flow. To use it, reference it in the
\code{auth_flow} argument of functions supporting it. Guards are
defined using the various \verb{guard_*()} constructors in the fireproof package.
Refer to these for further documentation
}
\section{Using annotation}{
To add a guard to your api defined in an annotated file use the
\verb{@authGuard} tag:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#* @authGuard BasicAuth
fireproof::guard_basic(...)
}\if{html}{\out{</div>}}

The tag parameter (\code{BasicAuth}) provides the name for the guard
}

\examples{
guard <- fireproof::guard_key(
  key_name = "plumber2-key",
  validate = "MY_VERY_SECRET_KEY"
)

api() |>
  api_datastore(storr::driver_environment()) |>
  api_auth_guard(guard, "cookie_key")

}
