% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC_psem.R
\name{AIC_psem}
\alias{AIC_psem}
\title{Information criterion values for SEM}
\usage{
AIC_psem(
  modelList,
  AIC.type = "loglik",
  Cstat = NULL,
  add.claims = NULL,
  basis.set = NULL,
  direction = NULL,
  interactions = FALSE,
  conserve = FALSE,
  conditional = FALSE,
  .progressBar = FALSE
)
}
\arguments{
\item{modelList}{a list of structural equations}

\item{AIC.type}{whether the log-likelihood \code{"loglik"} or d-sep \code{"dsep"} AIC score 
should be reported. Default is \code{"loglik"}}

\item{Cstat}{Fisher's C statistic obtained from \code{fisherC}}

\item{add.claims}{an optional vector of additional independence claims (P-values) 
to be added to the basis set}

\item{basis.set}{An optional list of independence claims.}

\item{direction}{a vector of claims defining the specific directionality of any independence 
claim(s)}

\item{interactions}{whether interactions should be included in independence claims. 
Default is FALSE}

\item{conserve}{whether the most conservative P-value should be returned (See Details) 
Default is FALSE}

\item{conditional}{whether the conditioning variables should be shown in the table. 
Default is FALSE}

\item{.progressBar}{an optional progress bar. Default is FALSE}
}
\value{
a data.frame of AIC, AICc, d.f., and sample size
}
\description{
Information criterion values for SEM
}
\references{
Shipley, Bill, and Jacob C. Douma. "Generalized AIC and chi‐squared statistics 
for path models consistent with directed acyclic graphs." Ecology 101.3 (2020): e02960.

Shipley, Bill. "The AIC model selection method applied to path analytic models compared using 
a d‐separation test." Ecology 94.3 (2013): 560-564.
}
\author{
Jon Lefcheck <jslefche@gmail.com>, Jim Grace
}
