% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_cat_raster.R
\name{extract_cat_raster}
\alias{extract_cat_raster}
\title{Calculate Area Proportions for Categorical Raster Classes (Generic)}
\usage{
extract_cat_raster(spat_raster_cat, sf_hex_grid, proportion = TRUE)
}
\arguments{
\item{spat_raster_cat}{A single-layer \code{SpatRaster} object containing categorical
values.}

\item{sf_hex_grid}{An \code{sf} object containing polygonal geometries. The function
will use \code{h3_address} if present, otherwise it creates and uses a temporary \code{ID}
column for joining.}

\item{proportion}{Logical. If \code{TRUE} (default), the output values are the
proportion of the polygon area covered by each category (summing to 1 for the
covered area). If \code{FALSE}, the output is the raw sum of the coverage fraction (area).}
}
\value{
An \code{sf} object identical to \code{sf_hex_grid}, but with new columns
  appended for each categorical value found in the raster. Column names follow the
  pattern \code{<layer_name>_prop_<category_value>}. Columns are **numerically ordered**
  by the category value.
}
\description{
Extracts and calculates the **area proportion** of each categorical class (e.g., LULC)
found within each input polygon. This function uses area-weighting to ensure
highly accurate, sub-pixel zonal statistics.
}
\details{
This function replaces the simplistic, non-area-weighted \code{table()} counting
method with a robust custom function utilizing \code{dplyr} and the \code{coverage_fraction}
column from \code{exactextractr}. Key features include:
\itemize{
  \item **Area-Weighted Accuracy:** Uses \code{coverage_fraction} for precise results.
  \item **NA Filtering:** Excludes \code{NA} raster values to prevent a \code{prop_NaN} column.
  \item **Numerical Ordering:** Sorts the final output columns by category number (e.g., 70 before 80).
}
}
\examples{
\dontrun{
# Assuming 'lulc' is a categorical SpatRaster and 'hex_grid' is an sf polygon grid
# cat_data_p <- extract_cat_raster(lulc, hex_grid)
# head(cat_data_p)
}
}
