% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_import.R
\name{read_samples_df}
\alias{read_samples_df}
\title{Read writing samples from a data frame}
\usage{
read_samples_df(df, id_col = 1, text_col = 2)
}
\arguments{
\item{df}{A data frame or tibble containing at least two columns.}

\item{id_col}{Column specifying the IDs. Can be a column name (string)
or a column index (integer). Defaults to 1.}

\item{text_col}{Column specifying the writing samples (character).
Can be a column name or index. Defaults to 2.}
}
\value{
A tibble with columns:
\itemize{
\item \code{ID}: character ID for each sample
\item \code{text}: character string of the writing sample
}
Any remaining columns in \code{df} are retained unchanged.
}
\description{
This function extracts ID and text columns from a data frame and
enforces that IDs are unique. By default, it assumes the first
column is the ID and the second column is the text.
}
\examples{
df <- data.frame(
  StudentID = c("S1", "S2"),
  Response = c("This is sample 1.", "This is sample 2."),
  Grade = c(8, 9),
  stringsAsFactors = FALSE
)

samples <- read_samples_df(df, id_col = "StudentID", text_col = "Response")
samples

# Using the built-in example dataset
data("example_writing_samples")
samples2 <- read_samples_df(
  example_writing_samples[, c("ID", "text")],
  id_col   = "ID",
  text_col = "text"
)
head(samples2)

}
