% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_costeffectiveness.R
\name{plot_nb}
\alias{plot_nb}
\title{Plot (i)NMB or (i)NHB.}
\usage{
plot_nb(df, NMB = TRUE, comparators = TRUE, incremental = FALSE)
}
\arguments{
\item{df}{a dataframe obtained through `calculate_nb()`}

\item{NMB}{logical. Should the (i)NMBs be plotted? Default is TRUE, if FALSE, (i)NHBs are plotted.}

\item{comparators}{logical. Should the NMB/NHB for each comparator be plotted? Default is TRUE.}

\item{incremental}{logical. Should the incremental NMB/NHB be plotted? Default is FALSE}
}
\value{
A ggplot2 graph.
}
\description{
This function plots the Net Monetary Benefits (NMB) and Net Health Benefits (NHB) for each strategy and the incremental NMB and NHB (only pairwise comparison).
}
\details{
The use this function, the dataframe `df` should contain the variables `NMB_int`, `NMB_comp`, `iNMB`, `NHB_int`, `NHB_comp`, and `iNHB`. For instance, use the \code{\link{calculate_nb}} function to calculate these outcomes.
}
\examples{
# Calculate NB's at a willingness-to-pay threshold of 80000 per unit of effects
data("df_pa")
df_nmb <- calculate_nb(df = df_pa,
             e_int = "t_qaly_d_int",
             e_comp = "t_qaly_d_comp",
             c_int = "t_costs_d_int",
             c_comp = "t_costs_d_comp",
             wtp = 80000)

# Plot NMB's for each comparator
plot_nb(df = df_nmb,
        NMB = TRUE,
        comparators = TRUE)
}
