% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger-provider-noop.R
\name{otel_logger}
\alias{otel_logger}
\title{OpenTelemetry Logger Object}
\value{
Not applicable.
}
\description{
\link{otel_logger_provider} -> \link{otel_logger}
}
\details{
Usually you do not need to deal with otel_logger objects directly.
\code{\link[=log]{log()}} automatically sets up the logger for emitting the logs.

A logger object is created by calling the \code{get_logger()} method of an
\link{otel_logger_provider}.

You can use the \code{log()} method of the logger object to emit logs.

Typically there is a separate logger object for each instrumented R
package.
}
\section{Methods}{
\subsection{\code{logger$is_enabled()}}{

Whether the logger is active and emitting logs at a certain severity
level.

This is equivalent to the \code{\link[=is_logging_enabled]{is_logging_enabled()}} function.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{logger$is_enabled(severity = "info", event_id = NULL)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{severity}: Check if logs are emitted at this severity level.
\item \code{event_id}: Not implemented yet.
}
}

\subsection{Value}{

Logical scalar.
}

}

\subsection{\code{logger$get_minimum_severity()}}{

Get the current minimum severity at which the logger is emitting logs.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{logger_get_minimum_severity()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

Named integer scalar.
}

}

\subsection{\code{logger$set_minimum_severiry()}}{

Set the minimum severity for emitting logs.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{logger$set_minimum_severity(minimum_severity)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{minimum_severity}: Log severity, a string, one of
"trace", "trace2", "trace3", "trace4", "debug", "debug2", "debug3", "debug4", "info", "info2", "info3", "info4", "warn", "warn2", "warn3", "warn4", "error", "error2", "error3", "error4", "fatal", "fatal2", "fatal3", "fatal4".
}
}

\subsection{Value}{

Nothing.
}

}

\subsection{\code{logger$log()}}{

Log an OpenTelemetry log message.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{logger$log(
  msg = "",
  severity = "info",
  span_context = NULL,
  span_id = NULL,
  trace_id = NULL,
  trace_flags = NULL,
  timestamp = SYs.time(),
  observed_timestamp = NULL,
  attributes = NULL,
  .envir = parent.frame()
)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{msg}: Log message, may contain R expressions to evaluate within
braces.
\item \code{severity}: Log severity, a string, one of
"trace", "trace2", "trace3", "trace4", "debug", "debug2", "debug3", "debug4", "info", "info2", "info3", "info4", "warn", "warn2", "warn3", "warn4", "error", "error2", "error3", "error4", "fatal", "fatal2", "fatal3", "fatal4".
\item \code{span_context}: An \link{otel_span_context} object to associate the log
message with a span.
\item \code{span_id}: Alternatively to \code{span_context}, you can also specify
\code{span_id}, \code{trace_id} and \code{trace_flags} to associate a log message
with a span.
\item \code{trace_id}: Alternatively to \code{span_context}, you can also specify
\code{span_id}, \code{trace_id} and \code{trace_flags} to associate a log message
with a span.
\item \code{trace_flags}: Alternatively to \code{span_context}, you can also specify
\code{span_id}, \code{trace_id} and \code{trace_flags} to associate a log message
with a span.
\item \code{timestamp}: Time stamp, defaults to the current time. This is the
time the logged event occurred.
\item \code{observed_timestamp}: Observed time stamp, this is the time the
event was observed.
\item \code{attributes}: Optional attributes, see \code{\link[=as_attributes]{as_attributes()}} for the
possible values.
}
}

\subsection{Value}{

The logger object, invisibly.
}

}

\subsection{\code{logger$trace()}}{

The same as \code{logger$log()}, with \code{severity = "trace"}.
}

\subsection{\code{logger$debug()}}{

The same as \code{logger$log()}, with \code{severity = "debug"}.
}

\subsection{\code{logger$info()}}{

The same as \code{logger$log()}, with \code{severity = "info"}.
}

\subsection{\code{logger$warn()}}{

The same as \code{logger$log()}, with \code{severity = "warn"}.
}

\subsection{\code{logger$error()}}{

The same as \code{logger$log()}, with \code{severity = "error"}.
}

\subsection{\code{logger$fatal()}}{

The same as \code{logger$log()}, with \code{severity = "fatal"}.
}
}

\examples{
lp <- get_default_logger_provider()
lgr <- lp$get_logger()
platform <- utils::sessionInfo()$platform
lgr$log("This is a log message from {platform}.", severity = "trace")
}
\seealso{
Other low level logs API: 
\code{\link{get_default_logger_provider}()},
\code{\link{get_logger}()},
\code{\link{logger_provider_noop}},
\code{\link{otel_logger_provider}}
}
\concept{low level logs API}
