% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrm_stop_server.R
\name{osrm_stop}
\alias{osrm_stop}
\title{Stop an OSRM Server}
\usage{
osrm_stop(
  server = NULL,
  id = NULL,
  port = NULL,
  pid = NULL,
  wait = 1000L,
  quiet = FALSE
)
}
\arguments{
\item{server}{Optional \code{processx::process} object returned by \code{osrm_start_server()}.}

\item{id}{Optional character id from \code{osrm_servers()}.}

\item{port}{Optional integer TCP port.}

\item{pid}{Optional integer process id.}

\item{wait}{Integer milliseconds to wait for clean shutdown (default \code{1000}).}

\item{quiet}{Logical; suppress messages (default \code{FALSE}).}
}
\value{
A list with fields \code{id}, \code{pid}, \code{port}, \code{stopped} (logical).
}
\description{
Terminates an \code{osrm-routed} process launched by \code{osrm_start()} or
\code{osrm_start_server()}.
}
\details{
This function provides a flexible way to stop a running OSRM process. If no
arguments are specified, it defaults to stopping the most recently started
server that is still alive.

You can also stop a specific server by providing:
\itemize{
\item The \code{processx::process} object returned by \code{osrm_start()} or \code{osrm_start_server()}.
\item The server's \code{id}, \code{port}, or \code{pid} (use \code{osrm_servers()} to find these).
}
}
\examples{
\donttest{
if (identical(Sys.getenv("OSRM_EXAMPLES"), "true")) {
  install_dir <- osrm_install(
    version = "latest",
    path_action = "session",
    quiet = TRUE
  )

  # copy example OSM PBF into a temporary workspace to avoid polluting pkg data
  pbf_path <- system.file("extdata/cur.osm.pbf", package = "osrm.backend")
  osrm_dir <- file.path(tempdir(), paste0("osrm-", Sys.getpid()))
  dir.create(osrm_dir, recursive = TRUE)
  tmp_pbf <- file.path(osrm_dir, "cur.osm.pbf")
  file.copy(from = pbf_path, to = tmp_pbf, overwrite = TRUE)
  graph <- osrm_prepare_graph(tmp_pbf, overwrite = TRUE, threads = 1L)

  srv <- osrm_start_server(graph$osrm_job_artifact, port = 6000, threads = 1L)

  # Stop by passing the process object
  osrm_stop(srv)

  # Or stop by port after the process is registered
  osrm_stop(port = 6000)

  osrm_uninstall(
    dest_dir = install_dir,
    clear_path = TRUE,
    force = TRUE,
    quiet = TRUE
  )
  unlink(osrm_dir, recursive = TRUE)
}
}
}
\seealso{
\code{\link[=osrm_start]{osrm_start()}}, \code{\link[=osrm_servers]{osrm_servers()}}, \code{\link[=osrm_stop_all]{osrm_stop_all()}}
}
