% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_properties.R
\name{fp_border}
\alias{fp_border}
\alias{update.fp_border}
\title{Border properties object}
\usage{
fp_border(color = "black", style = "solid", width = 1)

\method{update}{fp_border}(object, color, style, width, ...)
}
\arguments{
\item{color}{border color - single character value (e.g. "#000000" or "black")}

\item{style}{border style - single character value : See Details for supported
border styles.}

\item{width}{border width - an integer value : 0>= value}

\item{object}{fp_border object}

\item{...}{further arguments - not used}
}
\description{
create a border properties object.
}
\details{
For Word output the following border styles are supported:
\itemize{
\item "none" or "nil" - No Border
\item "solid" or "single" - Single Line Border
\item "thick" - Single Line Border
\item "double" - Double Line Border
\item "dotted" - Dotted Line Border
\item "dashed" - Dashed Line Border
\item "dotDash" - Dot Dash Line Border
\item "dotDotDash" - Dot Dot Dash Line Border
\item "triple" - Triple Line Border
\item "thinThickSmallGap" - Thin, Thick Line Border
\item "thickThinSmallGap" - Thick, Thin Line Border
\item "thinThickThinSmallGap" - Thin, Thick, Thin Line Border
\item "thinThickMediumGap" - Thin, Thick Line Border
\item "thickThinMediumGap" - Thick, Thin Line Border
\item "thinThickThinMediumGap" - Thin, Thick, Thin Line Border
\item "thinThickLargeGap" - Thin, Thick Line Border
\item "thickThinLargeGap" - Thick, Thin Line Border
\item "thinThickThinLargeGap" - Thin, Thick, Thin Line Border
\item "wave" - Wavy Line Border
\item "doubleWave" - Double Wave Line Border
\item "dashSmallGap" - Dashed Line Border
\item "dashDotStroked" - Dash Dot Strokes Line Border
\item "threeDEmboss" or "ridge" - 3D Embossed Line Border
\item "threeDEngrave" or "groove" - 3D Engraved Line Border
\item "outset" - Outset Line Border
\item "inset" - Inset Line Border
}

For HTML output only a limited amount of border styles are supported:
\itemize{
\item "none" or "nil" - No Border
\item "solid" or "single" - Single Line Border
\item "double" - Double Line Border
\item "dotted" - Dotted Line Border
\item "dashed" - Dashed Line Border
\item "threeDEmboss" or "ridge" - 3D Embossed Line Border
\item "threeDEngrave" or "groove" - 3D Engraved Line Border
\item "outset" - Outset Line Border
\item "inset" - Inset Line Border
}

Non-supported Word border styles will default to "solid".
}
\examples{
fp_border()
fp_border(color = "orange", style = "solid", width = 1)
fp_border(color = "gray", style = "dotted", width = 1)

# modify object ------
border <- fp_border()
update(border, style = "dotted", width = 3)
}
\seealso{
Other functions for defining formatting properties: 
\code{\link{fp_cell}()},
\code{\link{fp_par}()},
\code{\link{fp_tab}()},
\code{\link{fp_tabs}()},
\code{\link{fp_text}()}
}
\concept{functions for defining formatting properties}
