% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFragmentAnnotations.R
\name{getFragmentAnnotations}
\alias{getFragmentAnnotations}
\title{Gets annotations in fragments.}
\usage{
getFragmentAnnotations(
  labbcat.url,
  transcript.id,
  participant.id,
  start,
  end,
  layer.ids,
  sep = " ",
  partial.containment = FALSE,
  no.progress = FALSE
)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{transcript.id}{The transcript ID (transcript name) of the sound recording, or
a vector of transcript IDs.}

\item{participant.id}{The participant ID of the annotations, or a vector of participant IDs.}

\item{start}{The start time in seconds, or a vector of start times.}

\item{end}{The end time in seconds, or a vector of end times.}

\item{layer.ids}{A vector of layer IDs.}

\item{sep}{The separator to use when concatenating labels when multiple annotations are
in the given interval.}

\item{partial.containment}{Whether to include annotations that are only partially
contained in the given interval.}

\item{no.progress}{TRUE to suppress visual progress bar. Otherwise, progress bar will be
shown when interactive().}
}
\value{
A data frame with three columns for each layer in layer.ids:
\itemize{
\item The annotation labels concatenated together
\item The start time of the first annotation
\item The end time of the last annotation
}
}
\description{
This function gets annotations between given start/end times on given layers. If more
than one annotation matches, labels are concatentated together.
}
\examples{
\dontrun{
## Get some span-layer intervales
topics <- getMatches(labbcat.url, list(topic = ".*quake.*"))

## Get concantenated word tokens for each topic annotation
topic.tokens <- getFragmentAnnotations(
    labbcat.url, topics$Transcript, topics$Participant, topics$topic.start, topics$topic.end,
    c("word"))
}
}
\seealso{
\itemize{
\item \link{getFragments}
\item \link{getSoundFragments}
}
}
\keyword{TextGrid}
\keyword{fragment}
\keyword{sample}
