% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_film_permits.R
\name{nyc_film_permits}
\alias{nyc_film_permits}
\title{Film Permits}
\source{
NYC Open Data: <https://data.cityofnewyork.us/City-Government/Film-Permits/tg4x-b46p/about_data>
}
\usage{
nyc_film_permits(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing Film Permits data.
}
\description{
Downloads Film Permits data from NYC Open Data.
}
\details{
Permits are generally required when asserting the exclusive use of city property, like a sidewalk, a street, or a park.
See http://www1.nyc.gov/site/mome/permits/when-permit-required.page
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_film_permits(limit = 10)
head(small_sample)

\donttest{
nyc_film_permits(limit = 5000)
nyc_film_permits(filters = list(eventtype = "Shooting Permit"))
}
}
