% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdesign_helper.R
\name{simdesign_distinct}
\alias{simdesign_distinct}
\title{Add a distinct simdesign to a nl object}
\usage{
simdesign_distinct(nl, nseeds)
}
\arguments{
\item{nl}{nl object with a defined experiment}

\item{nseeds}{number of seeds for this simulation design}
}
\value{
simdesign S4 class object
}
\description{
Add a distinct simdesign to a nl object
}
\details{
This function creates a simdesign S4 class which can be added to a nl object.
The distinct simdesign allows to create a parameter matrix with distinct parameterisations.

Variables in the experiment variable list need to provide a vector of distinct values (e.g. list(values=c(1,2,3,4)).
All vectors of values must have the same length across variables.

The distinct simdesign then creates one simulation run for all first elements of these values vectors,
one run for all second items, and so on.
With this function, multiple distinct simulations can be run at once.
Finally, the function reports a simdesign object.
}
\examples{

# To attach a simdesign, a nl object needs to be created first (see ?nl).
# For this example, we load a nl object from test data.

nl <- nl_distinct
nl@simdesign <- simdesign_distinct(nl = nl, nseeds = 3)


}
