% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_tables.R
\name{gen_pest_table}
\alias{gen_pest_table}
\title{Makes \code{nlmixr2} Parameter Estimate Table for Reporting}
\usage{
gen_pest_table(obnd = NULL, fit = NULL, rptdetails = NULL, verbose = TRUE)
}
\arguments{
\item{obnd}{onbrand report object to have report elements appended to}

\item{fit}{nlmixr2 fit object to be reported}

\item{rptdetails}{object creating when reading in rptyaml file}

\item{verbose}{Boolean variable when set to TRUE (default) messages will be
displayed on the terminal}
}
\value{
List with the following elements
\itemize{
\item \code{"isgood"}  - Boolean variable indicating success or failure
\item \code{"msgs"}    - Vector of messages
\item \code{"ft"}      - Parameter estimates as a \code{flextable} object
\item \code{"df"}      - Parameter estimates as a \code{data.frame}
}
}
\description{
Generates a flextable containting the parameter estimates.
}
\examples{
library(onbrand)  
obnd = read_template(
 template = system.file(package="nlmixr2rpt", "templates","nlmixr_obnd_template.pptx"),
 mapping  = system.file(package="nlmixr2rpt", "templates","nlmixr_obnd_template.yaml"))

# This will create an example fit object to use in the examples below
fit = fetch_fit_example()

#'# This reads in the report details as well
rptdetails = yaml_read_fit(
 obnd    = obnd,
 rptyaml = system.file(package="nlmixr2rpt", "examples", "report_fit_test.yaml"),
 fit     = fit)$rptdetails

gen_pest_table(obnd = obnd, fit = fit, rptdetails = rptdetails, verbose = TRUE)
}
