% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx.vc.R
\name{approx.vc}
\alias{approx.vc}
\title{Approximate volume of distribution from observed Cmax}
\usage{
approx.vc(
  dat = NULL,
  half_life = NULL,
  single_point_base.lst = NULL,
  route = c("bolus", "oral", "infusion"),
  dose_type = NULL,
  pooled_ctrl = pooled_control(),
  ssctrl = ss_control()
)
}
\arguments{
\item{dat}{A data frame containing pharmacokinetic data, including observed
concentrations (DV), time after dose (tad), dose, and route information.}

\item{half_life}{The elimination half-life (t1/2) of the compound,
used to identify early-phase Cmax values.}

\item{single_point_base.lst}{Optional list object returned by
\link{run_single_point_base}(). If not supplied, the function will generate it internally.}

\item{route}{Route of administration. One of "bolus", "oral",
or "infusion" (default = "bolus").}

\item{dose_type}{Optional string specifying the dosing type, passed to
\link{run_single_point_base}().}

\item{pooled_ctrl}{Control object created by \link{pooled_control}(),
defining data pooling options.}

\item{ssctrl}{Control object created by \link{ss_control}(),
defining steady-state control options.}
}
\value{
A list containing individual and population Vd estimates and related dose-level data.
}
\description{
Estimates the volume of distribution (Vd) from observed peak
concentrations (Cmax) in single-dose, multiple-dose, or mixed datasets.
}
\details{
Estimates individual apparent volumes of distribution from observed peak concentrations.
Individual estimates are then summarized to obtain a population-level value.

For single-dose data, Vd is calculated according to the route of administration:
\itemize{
\item Bolus: \eqn{V_d = \mathrm{Dose} / C_{\mathrm{max}}}
\item Infusion: \eqn{V_d = (\mathrm{Rate} \times t_{\mathrm{inf}}) / C_{\mathrm{max}}}
\item Oral: \eqn{V_d = (\mathrm{Dose} \times F) / C_{\mathrm{max}}}, where \eqn{F = 1 - e^{-k_a t}}
}

For multiple-dose data, observed Cmax values are adjusted to
single-dose equivalents using the accumulation ratio:
\deqn{R_{\mathrm{ac}} = \frac{1}{1 - e^{-k_e \tau}}, \quad k_e = \ln(2)/t_{1/2}}
Adjusted values are used to estimate Vd using the same route-specific equations.
}
\examples{
# Process dataset
out <- processData(Bolus_1CPT)
# Get half-life and dose route
hf <- get_hf(dat = out$dat)$half_life_median
rt <- out$Datainfo$Value[out$Datainfo$Infometrics == "Dose Route"]
# Estimate Vd
approx.vc(dat = out$dat, half_life = hf, route = rt)$approx.vc.value
}
\seealso{
\code{\link{run_single_point_base}}, \code{\link{trimmed_geom_mean}},
\code{\link{pooled_control}}, \code{\link{ss_control}}
}
\author{
Zhonghui Huang
}
