% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchlight.R
\name{random_searchlight}
\alias{random_searchlight}
\title{Create a spherical random searchlight iterator}
\usage{
random_searchlight(mask, radius, nonzero = TRUE)
}
\arguments{
\item{mask}{A \code{\linkS4class{NeuroVol}} object representing the brain mask.}

\item{radius}{A numeric value specifying the radius of the searchlight sphere in voxel units.}

\item{nonzero}{Logical; if \code{TRUE} (default) discard zero-valued voxels in
the mask when forming each searchlight.}
}
\value{
A list of \code{\linkS4class{ROIVolWindow}} objects, each representing
  a spherical searchlight region.
}
\description{
This function generates a spherical random searchlight iterator for analyzing
local neighborhoods of voxels within a given radius in a brain mask.
}
\examples{
# Create a simple brain mask
mask_data <- array(TRUE, c(10, 10, 10))
mask_data[1, 1, 1] <- FALSE
mask <- LogicalNeuroVol(mask_data, NeuroSpace(c(10,10,10)))

# Generate random searchlight iterator with a radius of 2 voxels
\donttest{
searchlights <- random_searchlight(mask, radius = 6)
}

}
