% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-montage.R
\name{plot_montage}
\alias{plot_montage}
\title{Plot a montage of axial (or any-plane) slices using facetting}
\usage{
plot_montage(
  x,
  zlevels = NULL,
  along = 3L,
  cmap = "grays",
  range = c("robust", "data"),
  probs = c(0.02, 0.98),
  ncol = 6L,
  downsample = 1L,
  title = NULL,
  subtitle = NULL,
  caption = NULL
)
}
\arguments{
\item{x}{Either a 3D volume object accepted by `slice()` or a list of slices.}

\item{zlevels}{Integer indices of slices to plot (if `x` is a volume).}

\item{along}{Axis along which to slice (1 = sagittal, 2 = coronal, 3 = axial).}

\item{cmap}{Palette name or vector (see [resolve_cmap()]).}

\item{range}{"robust" (quantile-based) or "data" (min/max).}

\item{probs}{Quantiles for `range="robust"`.}

\item{ncol}{Number of columns in the facet layout.}

\item{downsample}{Integer decimation for speed.}

\item{title, subtitle, caption}{Optional ggplot labels.}
}
\description{
This avoids extra dependencies by using a single ggplot with facets
and a shared colorbar. Supply a list of slice objects or a volume + indices.
}
