% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti_extensions.R
\name{parse_afni_extension}
\alias{parse_afni_extension}
\title{Parse AFNI Extension}
\usage{
parse_afni_extension(ext, as_xml = TRUE)
}
\arguments{
\item{ext}{A \code{\link{NiftiExtension-class}} object with ecode = 4.}

\item{as_xml}{Logical; if TRUE (default) and xml2 is available, returns an
xml_document object. Otherwise returns the raw XML string.}
}
\value{
If \code{as_xml = TRUE} and xml2 is available, returns an xml_document.
  Otherwise returns a character string containing the XML.
}
\description{
Parses an AFNI extension (ecode = 4) containing XML-formatted attributes.
}
\details{
AFNI stores dataset attributes in an XML format within the NIfTI extension.
The XML contains elements like HISTORY_NOTE, volume labels, tagged points,
and other AFNI-specific metadata.
}
\examples{
\dontrun{
# Read a NIfTI file with AFNI extension
hdr <- read_nifti_header("afni_file.nii")
afni_ext <- hdr$extensions[[1]]
parsed <- parse_afni_extension(afni_ext)
}

}
\seealso{
\code{\link{get_afni_attribute}} for extracting specific AFNI attributes.
}
