% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mu_eta.R
\name{mu_eta}
\alias{mu_eta}
\title{Derivative of the Inverse Link Function}
\usage{
mu_eta(family, eta)
}
\arguments{
\item{family}{A character string specifying the distribution family:
one of \code{"gaussian"}, \code{"binomial"}, or \code{"poisson"}.}

\item{eta}{Numeric vector of linear predictor values.}
}
\value{
A numeric vector of the same length as \code{eta}, containing
the derivative \eqn{d\mu/d\eta}.
}
\description{
Computes the derivative of the inverse link function \eqn{d\mu/d\eta}
for common distributtion families supported by \code{neuralGAM} (\code{"gaussian"}, \code{"binomial"},
\code{"poisson"}). This quantity is required when applying the delta method to obtain
standard errors on the response scale in \code{predict()}.
}
\details{
For a neuralGAM with linear predictor \eqn{\eta} and mean response \eqn{\mu}:
\deqn{\mu = g^{-1}(\eta),}
the derivative \eqn{d\mu/d\eta} depends on the family:
\itemize{
\item Gaussian (identity link): \eqn{d\mu/d\eta = 1}.
\item Binomial (logit link): \eqn{d\mu/d\eta = \mu (1-\mu)}.
\item Poisson (log link): \eqn{d\mu/d\eta = \mu}.
}
Internally, values of \eqn{\eta} are clamped to avoid numerical
overflow/underflow in \code{exp()} and \eqn{\mu} is constrained away
from \eqn{0} and \eqn{1} for stability.
}
\seealso{
\code{\link{inv_link}}, \code{\link{link}}
}
\author{
Ines Ortega-Fernandez, Marta Sestelo
}
\keyword{internal}
