% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainty_estimation.R
\name{.combine_uncertainties_variance}
\alias{.combine_uncertainties_variance}
\title{Internal helper: combine epistemic and aleatoric via variance decomposition}
\usage{
.combine_uncertainties_variance(
  lwr_mat,
  upr_mat,
  mean_mat,
  alpha = 0.05,
  centerline = NULL
)
}
\arguments{
\item{lwr_mat}{\code{[passes, n_obs]} lower-quantile predictions per pass.}

\item{upr_mat}{\code{[passes, n_obs]} upper-quantile predictions per pass.}

\item{mean_mat}{\code{[passes, n_obs]} mean-head predictions per pass.}

\item{alpha}{Coverage level (default 0.05).}

\item{centerline}{Optional numeric vector (length n_obs) of deterministic
mean predictions to use as the PI center. If NULL, uses the across-pass mean.}
}
\value{
data.frame with columns:
\itemize{
\item lwr, upr: lower/upper predictive interval (Normal-theory)
\item var_epistemic: variance across passes of mean predictions
\item var_aleatoric: average per-pass aleatoric variance (from quantile width)
\item var_total: sum of epistemic and aleatoric variances
}
}
\description{
Classical combination of uncertainties without sampling. Assumes the same
input shapes as \code{.combine_uncertainties_sampling}: each argument is a matrix
of shape \code{[passes, n_obs]}, where rows index MC-Dropout passes and columns
index observations.

For each observation (column):
\itemize{
\item Epistemic variance = variance across passes of the mean head.
\item Aleatoric variance = average (across passes) of per-pass variance
estimated from quantile width via Normal approximation.
\item Total variance = epistemic + aleatoric.
\item Predictive interval = Normal-theory interval around the chosen centerline.
}
}
\author{
Ines Ortega-Fernandez, Marta Sestelo
}
\keyword{internal}
