% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpspline.R
\name{mpspline_fit1}
\alias{mpspline_fit1}
\title{Fit spline parameters}
\usage{
mpspline_fit1(
  s = NULL,
  p = NULL,
  var_name = NULL,
  d = NULL,
  vhigh = NULL,
  vlow = NULL
)
}
\arguments{
\item{s}{data.frame; data for one site}

\item{p}{list; estimated spline parameters for one site from
\code{\link[mpspline2:mpspline_est1]{mpspline_est1}}}

\item{var_name}{character or integer vector denoting the column(s) in
\code{obj} in which target data is stored. If not supplied, the fourth
column of the input object is assumed to contain the target data.}

\item{d}{sequential integer vector; denotes the output depth ranges in cm.
Defaults to \code{c(0, 5, 15, 30, 60, 100, 200)} after the GlobalSoilMap
specification, giving output predictions over intervals 0-5cm, 5-15cm,
etc.}

\item{vhigh}{numeric; constrains the maximum predicted value to a realistic
number. Defaults to 1000.}

\item{vlow}{numeric; constrains the minimum predicted value to a realistic
number. Defaults to 0.}
}
\value{
list of two vectors: fitted values at 1cm intervals and the average
  of same over the requested depth ranges.
}
\description{
Fit spline parameters to data for a single site.
}
\keyword{internal}
