% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{list_fns}
\alias{list_fns}
\title{List Database Functions (DuckDB/MotherDuck)}
\usage{
list_fns(.con)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}
}
\value{
A \code{dbplyr} lazy tibble (\code{tbl_dbi}) with function metadata (e.g.,
\code{function_name}, \code{schema}, \code{is_aggregate}, \code{is_alias}, etc.).
}
\description{
Returns a lazy table listing available SQL functions from the current
DuckDB/MotherDuck connection using \code{duckdb_functions()}.
}
\details{
This wrapper validates the connection and then queries
\code{duckdb_functions()} to enumerate function metadata. The result is a
\code{dbplyr} lazy tibble (\code{tbl_dbi}); call \code{collect()} to materialize it in R.
}
\seealso{
Other db-list: 
\code{\link{list_all_databases}()},
\code{\link{list_all_tables}()},
\code{\link{list_current_schemas}()},
\code{\link{list_current_tables}()},
\code{\link{list_extensions}()},
\code{\link{list_setting}()},
\code{\link{list_shares}()}
}
\concept{db-list}
