% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_create_obj}
\alias{cli_create_obj}
\title{Database, Schema, and Table Creator}
\usage{
cli_create_obj(.con, database_name, schema_name, table_name, write_type)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{database_name}{The name of the database to create or insert into. If missing, the current database is used.}

\item{schema_name}{The name of the schema to create or insert into. If missing, the current schema is used.}

\item{table_name}{The name of the table to create or insert into. If missing, no table-specific action is taken.}

\item{write_type}{Specifies the type of write operation. Used to describe whether an existing table is updated
(e.g., "insert" or "update").}
}
\value{
This function doesn't return any value. It generates a formatted report showing whether a new database, schema,
or table was created or if existing ones were used.
}
\description{
This function creates or inserts data into a specified database, schema, and table. If no database,
schema, or table is provided, the function attempts to use the current database, schema, or table.
It first checks if the provided database, schema, or table exists, and then either creates a new one
or inserts into the existing one, based on the given parameters. It generates an action report
indicating the status of the operation, whether a new database, schema, or table was created or
whether existing ones were used.
}
\keyword{internal}
