% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_maps.R
\name{plot_single_map}
\alias{plot_single_map}
\title{Build a tmap for a single variable}
\usage{
plot_single_map(sf_data, var, title, palette = "reds")
}
\arguments{
\item{sf_data}{An sf object containing spatial data.}

\item{var}{Variable name as a string to map.}

\item{title}{Legend title for the fill legend.}

\item{palette}{Color palette for the map (default is "reds").}
}
\value{
A tmap object representing the thematic map.
}
\description{
Creates a thematic map using the \code{tmap} package for a single variable in an sf object.
}
\examples{
\donttest{
library(sf)
# Create example sf object
nc <- st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)
nc$incidence <- runif(nrow(nc), 0, 100)

# Plot
p1 <- plot_single_map(nc, "incidence", "Incidence")
}
}
