% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TorchLoss.R
\name{cross_entropy}
\alias{cross_entropy}
\title{Cross Entropy Loss}
\description{
The \code{cross_entropy} loss function selects the multi-class (\code{\link[torch:nn_cross_entropy_loss]{nn_cross_entropy_loss}})
or binary (\code{\link[torch:nn_bce_with_logits_loss]{nn_bce_with_logits_loss}}) cross entropy
loss based on the number of classes.
Because of this, there is a slight reparameterization of the loss arguments, see \emph{Parameters}.
}
\section{Parameters}{

\itemize{
\item \code{class_weight}:: \code{\link[torch:torch_tensor]{torch_tensor}}\cr
The class weights. For multi-class problems, this must be a \code{torch_tensor} of length \code{num_classes}
(and is passed as argument \code{weight} to \code{\link[torch:nn_cross_entropy_loss]{nn_cross_entropy_loss}}).
For binary problems, this must be a scalar (and is passed as argument \code{pos_weight} to
\code{\link[torch:nn_bce_with_logits_loss]{nn_bce_with_logits_loss}}).
}
\itemize{
\item \code{ignore_index}:: \code{integer(1)}\cr
Index of the class which to ignore and which does not contribute to the gradient.
This is only available for multi-class loss.
\item \code{reduction} :: \code{character(1)}\cr
The reduction to apply. Is either \code{"mean"} or \code{"sum"} and passed as argument \code{reduction}
to either loss function. The default is \code{"mean"}.
}
}

\examples{
\dontshow{if (torch::torch_is_installed()) withAutoprint(\{ # examplesIf}
loss = t_loss("cross_entropy")
# multi-class
multi_ce = loss$generate(tsk("iris"))
multi_ce

# binary
binary_ce = loss$generate(tsk("sonar"))
binary_ce
\dontshow{\}) # examplesIf}
}
