% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplicity.R
\name{Multiplicity}
\alias{Multiplicity}
\title{Multiplicity}
\usage{
Multiplicity(...)
}
\arguments{
\item{\dots}{\code{any}\cr
Can be anything.}
}
\value{
\code{\link{Multiplicity}}
}
\description{
A \code{\link{Multiplicity}} class S3 object.

The function of multiplicities is to indicate that \code{\link{PipeOp}}s should be executed
multiple times with multiple values.

A \code{\link{Multiplicity}} is a container, like a
\code{list()}, that contains multiple values. If the message that is passed along the
edge of a \code{\link{Graph}} is a \code{\link{Multiplicity}}-object, then the \code{\link{PipeOp}} that receives
this object will \emph{usually} be called once for each contained value. The result of
each of these calls is then, again, packed in a \code{\link{Multiplicity}} and sent along the
outgoing edge(s) of that \code{\link{PipeOp}}. This means that a \code{\link{Multiplicity}} can cause
multiple \code{\link{PipeOp}}s in a row to be run multiple times, where the run for each element
of the \code{\link{Multiplicity}} is independent from the others.

Most \code{\link{PipeOp}}s only return a \code{\link{Multiplicity}} if their input was a \code{\link{Multiplicity}}
(and after having run their code multiple times, once for each entry). However,
there are a few special \code{\link{PipeOp}}s that are "aware" of \code{\link{Multiplicity}} objects. These
may either \emph{create} a \code{\link{Multiplicity}} even though not having a \code{\link{Multiplicity}} input
(e.g. \code{\link{PipeOpReplicate}} or \code{\link{PipeOpOVRSplit}}) -- causing the subsequent \code{\link{PipeOp}}s
to be run multiple times -- or \emph{collect} a \code{\link{Multiplicity}}, being called only once
even though their input is a \code{\link{Multiplicity}} (e.g. \code{\link{PipeOpOVRUnite}} or \code{\link{PipeOpFeatureUnion}}
if constructed with the \code{collect_multiplicity} argument set to \code{TRUE}). The combination
of these mechanisms makes it possible for parts of a \code{\link{Graph}} to be called variably
many times if "sandwiched" between \code{\link{Multiplicity}} creating and collecting \code{\link{PipeOp}}s.

Whether a \code{\link{PipeOp}} creates or collects a \code{\link{Multiplicity}} is indicated by the \verb{$input}
or \verb{$output} slot (which indicate names and types of in/out channels). If the \code{train} and
\code{predict} types of an input or output are surrounded by square brackets ("\code{[}", "\verb{]}"), then
this channel handles a \code{\link{Multiplicity}} explicitly. Depending on the function of the \code{\link{PipeOp}},
it will usually collect (input channel) or create (output channel) a \code{\link{Multiplicity}}.
\code{\link{PipeOp}}s without this indicator are \code{\link{Multiplicity}} agnostic and blindly execute their
function multiple times when given a \code{\link{Multiplicity}}.

If a \code{\link{PipeOp}} is trained on a \code{\link{Multiplicity}}, the \verb{$state} slot is set to a \code{\link{Multiplicity}}
as well; this \code{\link{Multiplicity}} contains the "original" \verb{$state} resulting from each individual
call of the \code{\link{PipeOp}} with the input \code{\link{Multiplicity}}'s content. If a \code{\link{PipeOp}} was trained
with a \code{\link{Multiplicity}}, then the \code{predict()} argument must be a \code{\link{Multiplicity}} with the same
number of elements.
}
\seealso{
Other Special Graph Messages: 
\code{\link{NO_OP}}

Other Experimental Features: 
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_replicate}}

Other Multiplicity PipeOps: 
\code{\link{PipeOpEnsemble}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_replicate}}
}
\concept{Experimental Features}
\concept{Multiplicity PipeOps}
\concept{Special Graph Messages}
