% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackAsyncFSelect.R
\name{CallbackAsyncFSelect}
\alias{CallbackAsyncFSelect}
\title{Asynchronous Feature Selection Callback}
\description{
Specialized \link[bbotk:CallbackAsync]{bbotk::CallbackAsync} for asynchronous feature selection.
Callbacks allow to customize the behavior of processes in mlr3fselect.
The \code{\link[=callback_async_fselect]{callback_async_fselect()}} function creates a \link{CallbackAsyncFSelect}.
Predefined callbacks are stored in the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_callbacks} and can be retrieved with \code{\link[=clbk]{clbk()}}.
For more information on feature selection callbacks see \code{\link[=callback_async_fselect]{callback_async_fselect()}}.
}
\section{Super classes}{
\code{\link[mlr3misc:Callback]{mlr3misc::Callback}} -> \code{\link[bbotk:CallbackAsync]{bbotk::CallbackAsync}} -> \code{CallbackAsyncFSelect}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{on_eval_after_xs}}{(\verb{function()})\cr
Stage called after xs is passed.
Called in \code{ObjectiveFSelectAsync$eval()}.}

\item{\code{on_resample_begin}}{(\verb{function()})\cr
Stage called at the beginning of an evaluation.
Called in \code{workhorse()} (internal).}

\item{\code{on_resample_before_train}}{(\verb{function()})\cr
Stage called before training the learner.
Called in \code{workhorse()} (internal).}

\item{\code{on_resample_before_predict}}{(\verb{function()})\cr
Stage called before predicting.
Called in \code{workhorse()} (internal).}

\item{\code{on_resample_end}}{(\verb{function()})\cr
Stage called at the end of an evaluation.
Called in \code{workhorse()} (internal).}

\item{\code{on_eval_after_resample}}{(\verb{function()})\cr
Stage called after feature subsets are evaluated.
Called in \code{ObjectiveFSelectAsync$eval()}.}

\item{\code{on_eval_before_archive}}{(\verb{function()})\cr
Stage called before performance values are written to the archive.
Called in \code{ObjectiveFSelectAsync$eval()}.}

\item{\code{on_fselect_result_begin}}{(\verb{function()})\cr
Stage called before the results are written.
Called in \verb{FSelectInstance*$assign_result()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CallbackAsyncFSelect-clone}{\code{CallbackAsyncFSelect$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Callback" data-id="call"><a href='../../mlr3misc/html/Callback.html#method-Callback-call'><code>mlr3misc::Callback$call()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Callback" data-id="format"><a href='../../mlr3misc/html/Callback.html#method-Callback-format'><code>mlr3misc::Callback$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Callback" data-id="help"><a href='../../mlr3misc/html/Callback.html#method-Callback-help'><code>mlr3misc::Callback$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Callback" data-id="initialize"><a href='../../mlr3misc/html/Callback.html#method-Callback-initialize'><code>mlr3misc::Callback$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3misc" data-topic="Callback" data-id="print"><a href='../../mlr3misc/html/Callback.html#method-Callback-print'><code>mlr3misc::Callback$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackAsyncFSelect-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackAsyncFSelect-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackAsyncFSelect$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
