% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss.lm.fit.R
\name{miss.lm.fit}
\alias{miss.lm.fit}
\title{Fitting Linear Regression Model with Missing Values}
\usage{
miss.lm.fit(x, y, control = list())
}
\arguments{
\item{x}{design matrix with missingness \eqn{N \times p}{N * p}.}

\item{y}{response vector \eqn{N \times 1}{N * 1}.}

\item{control}{a list of parameters for controlling the fitting process. For \code{miss.lm.fit} this is passed to \code{\link{miss.lm.control}}.}
}
\value{
a list with following components:
\item{coefficients}{Estimated \eqn{\beta}{\beta}.}
\item{ll}{Observed log-likelihood.}
\item{s.resid}{Estimated standard error for residuals.}
\item{s.err}{Standard error for estimated parameters.}
\item{mu.X}{Estimated \eqn{\mu}{\mu}.}
\item{Sig.X}{Estimated \eqn{\Sigma}{\Sigma}.}
}
\description{
This function is used inside \code{miss.lm} to fit linear regression model with missing values, by EM algorithm.
}
\examples{
## For examples see example(miss.lm)
}
