% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_all}
\alias{check_all}
\title{Check all params that don't return a value}
\usage{
check_all(
  dataset,
  method,
  permute,
  kfold,
  perf_metric_function,
  perf_metric_name,
  groups,
  group_partitions,
  corr_thresh,
  seed,
  hyperparameters
)
}
\arguments{
\item{dataset}{Data frame with an outcome variable and other columns as
features. Alternatively, the input can be in \code{TreeSummarizedExperiment}
format.}

\item{method}{ML method. Options: \code{c("glmnet", "rf", "rpart2", "svmRadial", "xgbTree")}.
\itemize{
\item glmnet: linear, logistic, or multiclass regression
\item rf: random forest
\item rpart2: decision tree
\item svmRadial: support vector machine
\item xgbTree: xgboost
}}

\item{kfold}{Fold number for k-fold cross-validation (default: \code{5}).}

\item{perf_metric_function}{Function to calculate the performance metric to
be used for cross-validation and test performance. Some functions are
provided by caret (see \code{\link[caret:postResample]{caret::defaultSummary()}}). Defaults: binary
classification = \code{twoClassSummary}, multi-class classification =
\code{multiClassSummary}, regression = \code{defaultSummary}.}

\item{perf_metric_name}{The column name from the output of the function
provided to perf_metric_function that is to be used as the performance
metric. Defaults: binary classification = \code{"ROC"}, multi-class
classification = \code{"logLoss"}, regression = \code{"RMSE"}.}

\item{groups}{Vector of groups to keep together when splitting the data into
train and test sets. If the number of groups in the training set is larger
than \code{kfold}, the groups will also be kept together for cross-validation.
Length matches the number of rows in the dataset (default: \code{NULL}).}

\item{group_partitions}{Specify how to assign \code{groups} to the training and
testing partitions (default: \code{NULL}). If \code{groups} specifies that some
samples belong to group \code{"A"} and some belong to group \code{"B"}, then setting
\code{group_partitions = list(train = c("A", "B"), test = c("B"))} will result
in all samples from group \code{"A"} being placed in the training set, some
samples from \code{"B"} also in the training set, and the remaining samples from
\code{"B"} in the testing set. The partition sizes will be as close to
\code{training_frac} as possible. If the number of groups in the training set is
larger than \code{kfold}, the groups will also be kept together for
cross-validation.}

\item{corr_thresh}{For feature importance, group correlations above or equal
to \code{corr_thresh} (range \code{0} to \code{1}; default: \code{1}).}

\item{seed}{Random seed (default: \code{NA}). Your results will only be
reproducible if you set a seed.}

\item{hyperparameters}{Dataframe of hyperparameters (default \code{NULL}; sensible
defaults will be chosen automatically).}
}
\description{
Check all params that don't return a value
}
\author{
Kelly Sovacool, \email{sovacool@umich.edu}
}
\keyword{internal}
