% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict,mgwrsar-method}
\alias{predict,mgwrsar-method}
\title{predict method for mgwrsar model}
\usage{
\S4method{predict}{mgwrsar}(
  object,
  newdata,
  newdata_coords,
  W = NULL,
  type = "BPN",
  h_w = 100,
  kernel_w = "rectangle",
  maxobs = 4000,
  beta_proj = FALSE,
  method_pred = "TP",
  k_extra = 8,
  exposant = 8,
  ...
)
}
\arguments{
\item{object}{A model of class \code{\link{mgwrsar-class}}.}

\item{newdata}{a matrix or data.frame of new data.}

\item{newdata_coords}{a matrix of new coordinates, and eventually other variables if a General Kernel Product is used.}

\item{W}{the spatial weight matrix for models with  spatial autocorrelation.}

\item{type}{Type for BLUP estimator, default "BPN". If NULL use predictions without spatial bias correction.}

\item{h_w}{A bandwidth value for the spatial weight matrix}

\item{kernel_w}{kernel type for the spatial weight matrix. Possible types:
rectangle ("rectangle"), bisquare ("bisq"), tricube ("tcub"),
epanechnikov ("epane"), gaussian ("gauss")) .}

\item{maxobs}{maximum number of observations for exact calculation of solve(I- rho*W), default maxobs=4000.}

\item{beta_proj}{A boolean, if TRUE the function then return a two elements list(Y_predicted,Beta_proj_out)}

\item{method_pred}{If method_pred = 'TP' (default) prediction is done by recomputing a MGWRSAR model
with new-data as target points, else if method_pred in ('tWtp_model','model','shepard') a matrix
for projecting estimated betas is used (see details).}

\item{k_extra}{number of neighboors for local parameter extrapolation if shepard kernel is used, default 8.}

\item{exposant}{shapenig parameter for tds_mgtwr model, default 6.}

\item{...}{predict parameters forwarded.}
}
\value{
A vector of predictions if beta_proj is FALSE or a list with a vector named Y_predicted and a matrix named Beta_proj_out.

A vector of predictions.
}
\description{
predict method for mgwrsar model
}
\details{
if method_pred ='tWtp_model',  the weighting matrix for prediction is
based on the expected weights of outsample data if they were had been added to
insample data to estimate the corresponding MGWRSAR (see Geniaux 2022 for
further detail), if method_pred ='shepard'a shepard kernel with k_extra neighbours (default 8) is used and if method_pred='kernel_model' the same kernel
and number of neighbors as for computing the MGWRSAR model is used.
}
