% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/golden_search_2d_bandwidth.R
\name{golden_search_2d_bandwidth}
\alias{golden_search_2d_bandwidth}
\title{Optimization of 2D Bandwidths (Spatial and Temporal) using Golden Section Search}
\usage{
golden_search_2d_bandwidth(formula, data, coords, fixed_vars, kernels, Model,
                                  control, lower.bound.space, upper.bound.space,
                                  lower.bound.time, upper.bound.time,
                                  tolerance_s = 1e-06, tolerance_t = 1e-06,
                                  max_iter = 10)
}
\arguments{
\item{formula}{A formula object.}

\item{data}{A data frame containing the variables.}

\item{coords}{A matrix of coordinates (spatial indices).}

\item{fixed_vars}{Vector of names of variables with fixed coefficients.}

\item{kernels}{Vector of kernel types (e.g., c('gauss', 'gauss')).}

\item{Model}{Character string specifying the model type (e.g., 'GWR').}

\item{control}{List of control parameters.}

\item{lower.bound.space}{Numeric. Lower bound for the spatial bandwidth search.}

\item{upper.bound.space}{Numeric. Upper bound for the spatial bandwidth search.}

\item{lower.bound.time}{Numeric. Lower bound for the temporal bandwidth search.}

\item{upper.bound.time}{Numeric. Upper bound for the temporal bandwidth search.}

\item{tolerance_s}{Numeric. Convergence tolerance for the spatial dimension. Default is 1e-6.}

\item{tolerance_t}{Numeric. Convergence tolerance for the temporal dimension. Default is 1e-6.}

\item{max_iter}{Integer. Maximum number of iterations for the optimization loop. Default is 10.}
}
\value{
A list containing:
\item{minimum}{Vector of optimized bandwidths c(h_spatial, h_temporal).}
\item{objective}{Final AICc value.}
\item{model}{The fitted mgwrsar model object.}
}
\description{
This function optimizes spatial and temporal bandwidths simultaneously using
a 2D Golden Section Search approach. It is typically used internally by
\code{search_bandwidths} when \code{refine = TRUE} for
spatio-temporal models (Type 'GDT').
}
\seealso{
\code{\link{golden_search_bandwidth}}, \code{\link{search_bandwidths}}
}
