% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_metacor_consistency.R
\name{check_metacor_consistency}
\alias{check_metacor_consistency}
\title{Check internal consistency of meta-analytic summary data}
\usage{
check_metacor_consistency(
  df,
  tolerance_p = 0.01,
  tolerance_CI = 0.1,
  r_extreme = 0.99,
  interpret = FALSE
)
}
\arguments{
\item{df}{A data frame, typically the output of \code{metacor_dual()}.}

\item{tolerance_p}{Numeric. Maximum acceptable absolute difference between
reported and reconstructed p-values.}

\item{tolerance_CI}{Numeric. Maximum acceptable absolute difference between
reported and reconstructed confidence interval limits.}

\item{r_extreme}{Numeric. Threshold above which correlations (in absolute
value) are flagged as extreme.}

\item{interpret}{Logical. If \code{TRUE}, add character columns
\code{summary_int} (and \code{summary_con}, if applicable) with a
brief narrative interpretation of the flags for each study.}
}
\value{
The same data frame \code{df} with additional logical flag columns
(e.g., \code{flag_p_mismatch_int}, \code{flag_CI_mismatch_int}, etc.),
and, if \code{interpret = TRUE}, one or two character columns with
textual summaries.
}
\description{
This function takes the output of \code{metacor_dual()} and performs
a set of internal consistency checks (p-values, confidence intervals,
SD of the difference vs. feasible range, and extreme correlations).
Optionally, it also adds a human-readable interpretation of the
detected issues for each study.
}
\examples{
\dontrun{
  res <- metacor_dual(dat, MeanDifferences = TRUE)
  res_checked <- check_metacor_consistency(res, interpret = TRUE)
}
}
