% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rob.R
\name{rob}
\alias{rob}
\alias{print.rob}
\title{Risk of bias assessment}
\usage{
rob(
  item1,
  item2 = NULL,
  item3 = NULL,
  item4 = NULL,
  item5 = NULL,
  item6 = NULL,
  item7 = NULL,
  item8 = NULL,
  item9 = NULL,
  item10 = NULL,
  studlab = NULL,
  overall = NULL,
  weight = NULL,
  data = NULL,
  tool = gs("tool.rob"),
  domains = NULL,
  categories = NULL,
  cat1 = categories,
  cat2 = categories,
  cat3 = categories,
  cat4 = categories,
  cat5 = categories,
  cat6 = categories,
  cat7 = categories,
  cat8 = categories,
  cat9 = categories,
  cat10 = categories,
  cat.overall = categories,
  col = NULL,
  col1 = col,
  col2 = col,
  col3 = col,
  col4 = col,
  col5 = col,
  col6 = col,
  col7 = col,
  col8 = col,
  col9 = col,
  col10 = col,
  col.overall = col,
  symbols = NULL,
  symb1 = symbols,
  symb2 = symbols,
  symb3 = symbols,
  symb4 = symbols,
  symb5 = symbols,
  symb6 = symbols,
  symb7 = symbols,
  symb8 = symbols,
  symb9 = symbols,
  symb10 = symbols,
  symb.overall = symbols,
  legend = TRUE,
  overwrite = FALSE,
  warn = TRUE
)

\method{print}{rob}(x, legend = attr(x, "legend"), details = TRUE, ...)
}
\arguments{
\item{item1}{Risk of bias item 1 or a meta-analysis object of class
\code{meta} with information on risk of bias assessment.}

\item{item2}{Risk of bias item 2.}

\item{item3}{Risk of bias item 3.}

\item{item4}{Risk of bias item 4.}

\item{item5}{Risk of bias item 5.}

\item{item6}{Risk of bias item 6.}

\item{item7}{Risk of bias item 7.}

\item{item8}{Risk of bias item 8.}

\item{item9}{Risk of bias item 9.}

\item{item10}{Risk of bias item 10.}

\item{studlab}{Study labels.}

\item{overall}{Overall risk of bias assess.}

\item{weight}{Weight for each study.}

\item{data}{A data frame or a meta-analysis object of class
\code{meta}.}

\item{tool}{Risk of bias (RoB) tool.}

\item{domains}{A character vector with names of RoB domains.}

\item{categories}{Possible RoB categories.}

\item{cat1}{Possible categories for RoB item 1.}

\item{cat2}{Possible categories for RoB item 2.}

\item{cat3}{Possible categories for RoB item 3.}

\item{cat4}{Possible categories for RoB item 4.}

\item{cat5}{Possible categories for RoB item 5.}

\item{cat6}{Possible categories for RoB item 6.}

\item{cat7}{Possible categories for RoB item 7.}

\item{cat8}{Possible categories for RoB item 8.}

\item{cat9}{Possible categories for RoB item 9.}

\item{cat10}{Possible categories for RoB item 10.}

\item{cat.overall}{Possible categories for overall RoB.}

\item{col}{Colours for RoB categories.}

\item{col1}{Colours for categories for RoB item 1.}

\item{col2}{Colours for categories for RoB item 2.}

\item{col3}{Colours for categories for RoB item 3.}

\item{col4}{Colours for categories for RoB item 4.}

\item{col5}{Colours for categories for RoB item 5.}

\item{col6}{Colours for categories for RoB item 6.}

\item{col7}{Colours for categories for RoB item 7.}

\item{col8}{Colours for categories for RoB item 8.}

\item{col9}{Colours for categories for RoB item 9.}

\item{col10}{Colours for categories for RoB item 10.}

\item{col.overall}{Colours for categories for overall RoB.}

\item{symbols}{Corresponding symbols for RoB categories.}

\item{symb1}{Corresponding symbols for RoB item 1.}

\item{symb2}{Corresponding symbols for RoB item 2.}

\item{symb3}{Corresponding symbols for RoB item 3.}

\item{symb4}{Corresponding symbols for RoB item 4.}

\item{symb5}{Corresponding symbols for RoB item 5.}

\item{symb6}{Corresponding symbols for RoB item 6.}

\item{symb7}{Corresponding symbols for RoB item 7.}

\item{symb8}{Corresponding symbols for RoB item 8.}

\item{symb9}{Corresponding symbols for RoB item 9.}

\item{symb10}{Corresponding symbols for RoB item 10.}

\item{symb.overall}{Corresponding symbols for overall RoB.}

\item{legend}{A logical specifying whether legend with RoB domains
should be printed.}

\item{overwrite}{A logical indicating whether an existing risk of
bias table in a meta-analysis object should be overwritten.}

\item{warn}{A logical indicating whether warnings should be
printed.}

\item{x}{An object of class \code{rob}.}

\item{details}{A logical indicating whether to print details on
categories and colours.}

\item{\dots}{Additional printing arguments.}
}
\value{
A data frame with study labels and risk of bias items and
additional class "rob".
}
\description{
Create table with risk of bias assessment or add table to existing
meta-analysis
}
\details{
This function can be used to define a risk of bias (RoB) assessment
for a meta-analysis which can be shown in a forest plot
(\code{\link{forest.meta}}), summary weighted barplot
(\code{\link{barplot.rob}}) or traffic light plot
(\code{\link{traffic_light}}). It is also possible to extract the
risk of bias assessment from a meta-analysis with RoB information.

The risk of bias table contains

\itemize{
\item study labels;
\item variables for individual RoB domains (with variable names A,
  B, \dots);
\item an overall RoB assessment if argument \code{overall} is
  provided;
\item weights for individual studies used in summary weighted
  barplots.
}
Note, an overall RoB assessment is mandatory to create a summary
weighted barplot or a traffic light plot.

The RoB table is directly returned if argument \code{data} is a
data frame or argument \code{item1} is a meta-analysis with risk of
bias assessment. The RoB table is added as a new list element 'rob'
to a meta-analysis object if argument \code{data} is a
meta-analysis.

The user must either specify the categories and (optionally)
domains of the RoB tool (using the eponymous arguments) or one of
the following RoB tools.
\tabular{ll}{
\bold{Argument} \tab \bold{Risk of bias tool} \cr
\code{tool = "RoB1"} \tab RoB 1 tool for randomized studies
  (Higgins et al., 2011) \cr
\code{tool = "RoB2"} \tab RoB 2 tool for randomized studies
  (Sterne et al., 2019) \cr
\code{tool = "RoB2-cluster"} \tab RoB 2 tool for
  cluster-randomized trials \cr
\code{tool = "RoB2-crossover"} \tab RoB 2 tool for crossover
  trials \cr
\code{tool = "ROBINS-I"} \tab Risk Of Bias In Non-randomized
  Studies - of Interventions \cr
\tab (Sterne et al., 2016) \cr
\code{tool = "ROBINS-E"} \tab Risk Of Bias In Non-randomized
  Studies - of Exposures \cr
\tab (ROBINS-E Development Group, 2023)
}
These RoB tools are described on the website
\url{https://www.riskofbias.info/}.

\subsection{Risk of bias domains}{

By default, i.e., if argument \code{domains} is not provided by the
user, the following names are used for RoB domains.

\itemize{
\item RoB 1 tool for randomized studies (RoB1):

\enumerate{
 \item Random sequence generation (selection bias)
 \item Allocation concealment (selection bias)
 \item Blinding of participants and personnel (performance bias)
 \item Blinding of outcome assessment (detection bias)
 \item Incomplete outcome data (attrition bias)
 \item Selective reporting (reporting bias)
 \item Other bias
}

\item RoB 2 tool for randomized studies (RoB2):
\enumerate{
 \item Bias arising from the randomization process
 \item Bias due to deviations from intended intervention"
 \item Bias due to missing outcome data
 \item Bias in measurement of the outcome
 \item Bias in selection of the reported result
}

\item RoB 2 tool for cluster-randomized trials (RoB2-cluster):
\enumerate{
 \item Bias arising from the randomization process
 \item Bias arising from the identification or recruitment of
   participants into clusters
 \item Bias due to deviations from intended intervention
 \item Bias due to missing outcome data
 \item Bias in measurement of the outcome
 \item Bias in selection of the reported result
}

\item RoB 2 tool for crossover trials (RoB2-crossover)
\enumerate{
 \item Bias arising from the randomization process
 \item Bias arising from period and carryover effects
 \item Bias due to deviations from intended intervention
 \item Bias due to missing outcome data
 \item Bias in measurement of the outcome
 \item Bias in selection of the reported result
}

\item Risk Of Bias In Non-randomized Studies - of Intervention (ROBINS-I):
\enumerate{
 \item Risk of bias due to confounding
 \item Risk of bias in selection of participants into the study
 \item Risk of bias in classification of interventions
 \item Risk of bias due to deviations from intented interventions
 \item Risk of bias due to missing outcome data
 \item Risk of bias in measurement of the outcome
 \item Risk of bias in the selection of the reported results
}

\item Risk Of Bias In Non-randomized Studies - of Exposures (ROBINS-E):
\enumerate{
 \item Risk of bias due to confounding
 \item Risk of bias arising from measurement of the exposure into
   the study (or into the analysis)
 \item Risk of bias due to post-exposure interventions
 \item Risk of bias due to deviations from intented interventions
 \item Risk of bias due to missing outcome data
 \item Risk of bias in measurement of the outcome
 \item Risk of bias in the selection of the reported results
}

\item User-defined RoB assessment:
\enumerate{
 \item First item
 \item Second item
 \item \dots
}
}

It is possible to define additional bias domains for the available
RoB tools. In this case, only the names for new RoB domains have to
be provided in argument \code{domains}. If argument \code{domains}
is not used to specify new domains, the names "Additional item 1"
etc. will be used. It is also possible to modify the pre-defined
domain names using argument \code{domains}.

The maximum number of bias domains / items is ten (see arguments
\code{item1}, ..., \code{item10}).
}

\subsection{Risk of bias categories, colours and symbols}{

By default, the following settings are used.

RoB 1 tool:

\tabular{ll}{
\bold{Argument} \tab \bold{Values} \cr
\code{categories} \tab "Low risk of bias", "Unclear risk of bias",
  "High risk of bias" \cr
\code{col} \tab "green", "yellow", "red" \cr
\code{symbols} \tab "+", "?", "-"
}

RoB 2 tools:

\tabular{ll}{
\bold{Argument} \tab \bold{Values} \cr
\code{categories} \tab "Low risk of bias", "Some concerns",
  "High risk of bias" \cr
\code{col} \tab "green", "yellow", "red" \cr
\code{symbols} \tab "+", "?", "-"
}

ROBINS tools:

\tabular{ll}{
\bold{Argument} \tab \bold{Values} \cr
\code{categories} \tab "Low risk", "Some concerns", "High risk",
  "Very high risk", "NI" \cr
\code{col} \tab "green", "yellow", "red", "darkred", "darkgrey" \cr
\code{symbols} \tab none
}

User-defined RoB tools:

\tabular{ll}{
\bold{Argument} \tab \bold{Values} \cr
\code{categories} \tab Must be specified by the user \cr
\code{col} \tab 1, 2, ... \cr
\code{symbols} \tab none
}

If colours (\code{col}) and symbols (\code{symbols}) are provided,
they must be of the same length as the number of categories. 
}
}
\examples{
# Use RevMan 5 settings
oldset <- settings.meta("RevMan5", quietly = FALSE)

data(caffeine)

m1 <- metabin(h.caf, n.caf, h.decaf, n.decaf, sm = "OR",
  data = caffeine, studlab = paste(study, year))

# Add risk of bias assessment to meta-analysis
m2 <- rob(D1, D2, D3, D4, D5, overall = rob, data = m1, tool = "rob2")

# Print risk of bias assessment
rob(m2)

# Forest plot with risk of bias assessment
forest(m2)

# Use previous settings
settings.meta(oldset)

}
\references{
Higgins JPT, Altman DG, Gøtzsche PC, Jüni P, Moher D, Oxman AD et
al. (2011):
The Cochrane Collaboration's tool for assessing risk of bias in
randomised trials.
\emph{British Medical Journal}, \bold{343}: d5928

ROBINS-E Development Group (Higgins J, Morgan R, Rooney A et al.) (2023):
Risk Of Bias In Non-randomized Studies - of Exposure (ROBINS-E)
Available from: \url{https://www.riskofbias.info/welcome/robins-e-tool}.

Sterne JA, Hernán MA, Reeves BC, Savović J, Berkman ND, Viswanathan
M, et al. (2016):
ROBINS-I: a tool for assessing risk of bias in non-randomised
studies of interventions.
\emph{British Medical Journal}, \bold{355}: i4919

Sterne JAC, Savović J, Page MJ, Elbers RG, Blencowe NS, Boutron I,
et al. (2019):
RoB 2: a revised tool for assessing risk of bias in randomised trials.
\emph{British Medical Journal}, \bold{366}: l4898.
}
\seealso{
\code{\link{forest.meta}}, \code{\link{barplot.rob}},
  \code{\link{traffic_light}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
