% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AO_opt.R
\name{AO}
\alias{AO}
\title{Archimedes Optimization}
\usage{
AO(N, Max_iter, lb, ub, dim, fobj)
}
\arguments{
\item{N}{An integer indicate population size.}

\item{Max_iter}{An integer indicate maximum number of iterations.}

\item{lb}{A numeric vector that show lower bounds of the search space. One value per dimension.}

\item{ub}{A numeric vector that show upper bounds of the search space. One value per dimension.}

\item{dim}{An integer show the number of dimension (parameters) of the problem to optimize. It indicate the number of parameters to be optimized.}

\item{fobj}{An objective function used to be minimized. It is return single numeric value that show evaluation matrix result in every iteration.
It used to calculate the best fitness in every iteration.}
}
\value{
A list containing:
\describe{
  \item{best_fitness}{The best (minimum) fitness value found.}
  \item{best_position}{The parameter vector (position) corresponding to the best fitness.}
  \item{jml_iter}{The number of iterations executed.}
  \item{param}{Matrix of best parameters found across every iterations (dim × iter).}
  \item{param_list}{Vector of best fitness values at each iteration.}
}
}
\description{
An algorithm built by Hashim et al. (2021) use buoyancy law and fluid dynamics behavior
in Archimedes principle to optimized real-valued objective function in continuous search space
in a population-based manner.
}
\details{
This algorithm uses population-based search to conduct physical law such as volume, density difference, and acceleration in every iteration.
It balancing the exploration and exploitation phase by using Transfer Function (TF) as a shifting indicates.

The algorithm performs until maximum iteration reached or convergence condition when the difference
in objective values for ten consecutive times is less than 10^-5.
}
\note{
The input vectors 'lb' and 'ub' must have the same length as the number of dimensions 'dim'.

This optimization function used inside svrHybrid function.

Constant of C3 = 1 and C4 = 2 used in basic standard optimization function.
}
\examples{
{
sphere_fn <- function(x) sum(x^2) # simple function for objective function

# AO optimization
set.seed(123)
result <- AO(N = 20, Max_iter = 50, lb = c(-5,-5,-5), ub = c(5,5,5), dim = 3, fobj = sphere_fn)

# View best fitness and position found
result$best_fitness
result$best_position
}

}
\references{
Hashim, F. A., Hussain, K., Houssein, E. H., Mabrouk, M. S., & Al-Atabany, W. (2021).
Archimedes Optimization Algorithm: A New Metaheuristic Algorithm for Solving Optimization Problems.
Applied Intelligence, 51(3), 1531–1551. https://doi.org/10.1007/s10489-020-01893-z
}
