% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_twin.R
\name{mc_twin}
\alias{mc_twin}
\alias{mc_twin_bio}
\alias{mc_twin_full}
\title{Twin Model Covariance Structures}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression Models in R:
The mcglm Package. Journal of Statistical Software, 84(4), 1--30.
}
\usage{
mc_twin(id, twin.id, type, replicate = NULL, structure, data)

mc_twin_bio(id, twin.id, type, replicate = NULL, structure, data)

mc_twin_full(id, twin.id, type, replicate, formula, data)
}
\arguments{
\item{id}{A string indicating the name of the column in \code{data} that
identifies the twin pair. The same identifier must be shared by both
twins in a pair.}

\item{twin.id}{A string indicating the name of the column in \code{data} that
identifies the twin within each pair. Typically coded as \code{1} and
\code{2}.}

\item{type}{A string indicating the name of the column in \code{data} that
identifies the zygosity type. This variable must be a factor with
exactly two levels: \code{"mz"} and \code{"dz"}, where \code{"mz"} is
taken as the reference level.}

\item{replicate}{An optional string indicating the name of the column in \code{data}
that identifies replicated observations within the same twin pair,
such as time points in longitudinal twin studies. If provided, it is
treated as a factor.}

\item{structure}{A string specifying the covariance structure to be constructed.
Available options are \code{"full"}, \code{"flex"}, \code{"uns"},
\code{"ACE"}, \code{"ADE"}, \code{"AE"}, \code{"CE"} and \code{"E"}.}

\item{data}{A data frame containing all variables referenced by the model.}

\item{formula}{Internal argument used to define flexible and unstructured covariance
models. Not intended for direct user specification.}
}
\value{
A list of sparse matrices of class \code{dgCMatrix}, representing the
components of the matrix linear predictor to be used in the
\code{matrix_pred} argument of \code{\link{mcglm}}.
}
\description{
Constructs the components of the matrix linear predictor for twin data
analysis under ACDE-type models. The function generates covariance
structures suitable for monozygotic (MZ) and dizygotic (DZ) twins and
supports several biologically motivated and flexible model
parameterizations.
}
\details{
For biologically motivated structures (\code{"ACE"}, \code{"ADE"},
\code{"AE"}, \code{"CE"}, \code{"E"}), the function builds covariance
matrices based on classical twin modeling assumptions. For flexible
and unstructured options (\code{"full"}, \code{"flex"}, \code{"uns"}),
the covariance structure is constructed using matrix linear predictors.
}
\seealso{
\code{\link{mc_id}}, \code{\link{mc_dist}}, \code{\link{mc_car}},
\code{\link{mc_rw}}, \code{\link{mc_ns}}, \code{\link{mc_dglm}},
\code{\link{mc_mixed}}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
