% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_sic_covariance.R
\name{mc_sic_covariance}
\alias{mc_sic_covariance}
\title{Score Information Criterion for Covariance Components}
\usage{
mc_sic_covariance(object, scope, idx, data, penalty = 2, response, weights)
}
\arguments{
\item{object}{An object of class \code{mcglm}.}

\item{scope}{A list of matrices to be tested for inclusion in the matrix linear
predictor.}

\item{idx}{An integer vector indicating which matrices in \code{scope} belong to
the same effect. This is useful when more than one matrix represents
a single covariance component.}

\item{data}{A data frame containing all variables involved in the model.}

\item{penalty}{A numeric penalty term applied to the SIC (default is 2).}

\item{response}{An integer indicating the response variable for which the
SIC-covariance is computed.}

\item{weights}{An optional numeric vector of weights used in model fitting. If not
provided, unit weights are assumed.}
}
\value{
A data frame with the following columns:
\describe{
  \item{SIC}{Score Information Criterion value.}
  \item{df}{Degrees of freedom associated with the test.}
  \item{df_total}{Total number of covariance parameters in the extended model.}
  \item{Tu}{Score-based test statistic.}
  \item{Chisq}{Reference chi-squared quantile with 95\% confidence level.}
}
}
\description{
Computes the Score Information Criterion (SIC) for covariance
components of a fitted \code{mcglm} object. The SIC-covariance is used
to select components of the matrix linear predictor and can be
employed in stepwise selection procedures.
}
\details{
The SIC-covariance is computed using the Pearson estimating function.
For each group of matrices defined by \code{idx}, a score-based test
statistic is calculated to assess the contribution of the associated
covariance components, penalized by model complexity.
}
\examples{
set.seed(123)
SUBJECT <- gl(10, 10)
y <- rnorm(100)
data <- data.frame(y, SUBJECT)

Z0 <- mc_id(data)
Z1 <- mc_mixed(~ 0 + SUBJECT, data = data)

fit0 <- mcglm(
  linear_pred = c(y ~ 1),
  matrix_pred = list(Z0),
  data = data
)

mc_sic_covariance(
  fit0,
  scope = Z1,
  idx = 1,
  data = data,
  response = 1
)

}
\references{
Bonat, W. H., et al. (2016). Modelling the covariance structure in
marginal multivariate count models: Hunting in Bioko Island.
\emph{Journal of Agricultural, Biological and Environmental Statistics},
22(4), 446--464.

Bonat, W. H. (2018). Multiple Response Variables Regression Models in R:
The mcglm Package. \emph{Journal of Statistical Software}, 84(4), 1--30.
}
\seealso{
\code{\link{mc_sic}}
}
