/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.variables;

import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.reified.leaves.ConstantLeaf;
import choco.cp.solver.constraints.reified.leaves.VariableLeaf;
import choco.cp.solver.variables.integer.BooleanVarImpl;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.model.Model;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableManager;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.BitSet;
import java.util.Iterator;

public final class IntegerVariableManager
implements VariableManager<IntegerVariable> {
    private static final String CSTE = "CSTE_";

    protected static IntDomainVar makeConstant(CPSolver solver, IntegerVariable iv) {
        int value = iv.getLowB();
        IntDomainVarImpl v = (BooleanVarImpl)solver.getIntConstant(value);
        if (v == null) {
            if (iv.isBoolean()) {
                v = new BooleanVarImpl(solver, CSTE + value);
                v.getDomain().restrict(value);
            } else {
                v = new IntDomainVarImpl(solver, CSTE + value, 6, value, value);
            }
            solver.addIntConstant(value, v);
        }
        return v;
    }

    @Override
    public Var makeVariable(Solver solver, IntegerVariable var) {
        if (solver instanceof CPSolver) {
            IntDomainVarImpl v = null;
            if (var.isConstant()) {
                return IntegerVariableManager.makeConstant((CPSolver)solver, var);
            }
            if (var.isBoolean()) {
                v = new BooleanVarImpl(solver, var.getName());
            } else if (var.getValues() == null) {
                if (var.getLowB() != var.getUppB()) {
                    int type = var.getOptions().contains("cp:enum") ? 0 : (var.getOptions().contains("cp:bound") ? 1 : (var.getOptions().contains("cp:link") ? 2 : (var.getOptions().contains("cp:btree") ? 3 : (var.getOptions().contains("cp:blist") ? 4 : IntegerVariableManager.getIntelligentDomain(solver.getModel(), var)))));
                    v = new IntDomainVarImpl(solver, var.getName(), type, var.getLowB(), var.getUppB());
                }
            } else {
                int[] values = var.getValues();
                if (values.length > 1) {
                    int type = 0;
                    if (var.getOptions().contains("cp:link")) {
                        type = 2;
                    } else if (var.getOptions().contains("cp:btree")) {
                        type = 3;
                    } else if (var.getOptions().contains("cp:blist")) {
                        type = 4;
                    }
                    v = new IntDomainVarImpl(solver, var.getName(), type, values);
                }
            }
            ((CPSolver)solver).addIntVar(v);
            return v;
        }
        throw new ModelException("Could not found a variable manager in " + this.getClass() + " !");
    }

    @Override
    public INode makeNode(Solver solver, Constraint[] cstrs, Variable[] vars) {
        if (vars[0] instanceof IntegerConstantVariable) {
            IntegerConstantVariable c = (IntegerConstantVariable)vars[0];
            return new ConstantLeaf(c.getValue());
        }
        if (vars[0] instanceof IntegerVariable) {
            return new VariableLeaf((IntegerVariable)vars[0]);
        }
        return null;
    }

    public static int getIntelligentDomain(Model model, IntegerVariable v) {
        if (v.getLowB() <= -21474836 && v.getUppB() >= 21474836) {
            return 1;
        }
        int[] scoreForDomain = new int[10];
        BitSet posDom = new BitSet(10);
        posDom.set(0, 20);
        if (v.getValues() != null) {
            posDom.clear(1);
        }
        if (v.getUppB() - v.getLowB() + 1 == v.getDomainSize() && v.getDomainSize() > 300) {
            posDom.clear(0);
            posDom.clear(2);
        }
        Iterator<Constraint> it = v.getConstraintIterator(model);
        while (it.hasNext()) {
            Constraint cc = it.next();
            int[] prefereddoms = cc.getFavoriteDomains();
            if (prefereddoms.length <= 0) continue;
            BitSet posCdom = new BitSet(5);
            for (int i = 0; i < prefereddoms.length; ++i) {
                int n = prefereddoms[i];
                scoreForDomain[n] = scoreForDomain[n] + (i + 1);
                posCdom.set(prefereddoms[i]);
            }
            posDom.and(posCdom);
        }
        int bestDom = IntegerVariableManager.possibleArgMin(scoreForDomain, posDom);
        if (bestDom == -1) {
            throw new ModelException("no suitable domain for " + v + " that can be accepted by all constraints");
        }
        return bestDom;
    }

    public static int possibleArgMin(int[] tab, BitSet posDom) {
        int bestDom = -1;
        int minScore = Integer.MAX_VALUE;
        for (int i = 0; i < tab.length; ++i) {
            if (!posDom.get(i) || minScore <= tab[i]) continue;
            minScore = tab[i];
            bestDom = i;
        }
        return bestDom;
    }
}

