% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/I_ali.R
\name{I_ali}
\alias{I_ali}
\title{Albedo-reflected insolation on Mars inclined surface over time period}
\usage{
I_ali(
  Ls,
  phi,
  longitude,
  tau,
  Ts_start,
  Ts_end,
  al = albedo(latitude = phi, longitude = longitude, tau = tau),
  beta,
  gamma_c
)
}
\arguments{
\item{Ls}{Areocentric longitude [deg]}

\item{phi}{Planetary latitude [deg]}

\item{longitude}{Planetary longitude [deg]}

\item{tau}{Atmospheric optical depth (dimensionless)}

\item{Ts_start}{Start of integration period [h]}

\item{Ts_end}{End of integration period [h]}

\item{al}{Surface albedo (dimensionless, 0-1). If not provided, calculated from latitude, longitude, and tau}

\item{beta}{Surface tilt/slope angle from horizontal [deg]}

\item{gamma_c}{Surface azimuth angle [deg]. Zero facing equator, east negative, west positive (-180 to +180)}
}
\value{
Albedo-reflected insolation on inclined surface over specified time period [Wh/m²]
}
\description{
Calculates the ground-reflected solar energy received on an inclined surface between specified
start and end times. Obtained by integrating albedo-reflected irradiance over the time period.
}
