% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{add_fullscreen_control}
\alias{add_fullscreen_control}
\title{Add a fullscreen control to a map}
\usage{
add_fullscreen_control(map, position = "top-right")
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl} or \code{maplibre} functions.}

\item{position}{A string specifying the position of the fullscreen control.
One of "top-right", "top-left", "bottom-right", or "bottom-left".}
}
\value{
The modified map object with the fullscreen control added.
}
\description{
Add a fullscreen control to a map
}
\examples{
\dontrun{
library(mapgl)

maplibre(
    style = maptiler_style("streets"),
    center = c(11.255, 43.77),
    zoom = 13
) |>
    add_fullscreen_control(position = "top-right")
}
}
