% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp-get-ccaa.R
\encoding{UTF-8}
\name{esp_get_ccaa}
\alias{esp_get_ccaa}
\title{Autonomous Communities of Spain - GISCO}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}.

Copyright:
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/administrative-units}.
}
\usage{
esp_get_ccaa(ccaa = NULL, moveCAN = TRUE, ...)
}
\arguments{
\item{ccaa}{character string. A vector of names and/or codes for Autonomous
Communities or \code{NULL} to get all the autonomous communities. See
\strong{Details}.}

\item{moveCAN}{A logical \code{TRUE/FALSE} or a vector of coordinates
\code{c(lat, lon)}. It places the Canary Islands close to Spain's mainland.
Initial position can be adjusted using the vector of coordinates. See
\strong{Displacing the Canary Islands} in \code{\link[=esp_move_can]{esp_move_can()}}.}

\item{...}{
  Arguments passed on to \code{\link[=esp_get_nuts]{esp_get_nuts}}
  \describe{
    \item{\code{year}}{year character string or number. Release year of the file. See
\code{\link[giscoR:gisco_get_nuts]{giscoR::gisco_get_nuts()}} for valid values.}
    \item{\code{epsg}}{character string or number. Projection of the map: 4-digit
\href{https://epsg.io/}{EPSG code}. One of:
\itemize{
\item \code{"4258"}: \href{https://epsg.io/4258}{ETRS89}
\item \code{"4326"}: \href{https://epsg.io/4326}{WGS84}.
\item \code{"3035"}: \href{https://epsg.io/3035}{ETRS89 / ETRS-LAEA}.
\item \code{"3857"}: \href{https://epsg.io/3857}{Pseudo-Mercator}.
}}
    \item{\code{cache}}{logical. Whether to do caching. Default is \code{TRUE}. See
\strong{Caching strategies} section in \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.}
    \item{\code{update_cache}}{logical. Should the cached file be refreshed? Default
is \code{FALSE}. When set to \code{TRUE}, it will force a new download.}
    \item{\code{cache_dir}}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.}
    \item{\code{spatialtype}}{character string. Type of geometry to be returned.
Options available are:
\itemize{
\item "RG": Regions - \code{MULTIPOLYGON/POLYGON} object.
\item "LB": Labels - \code{POINT} object.
}}
    \item{\code{ext}}{character. Extension of the file (default \code{"gpkg"}). See
\code{\link[giscoR:gisco_get_nuts]{giscoR::gisco_get_nuts()}}.}
    \item{\code{verbose}}{logical. If \code{TRUE} displays informational messages.}
    \item{\code{resolution}}{character string or number. Resolution of the geospatial
data. One of:
\itemize{
\item \code{"60"}: 1:60 million.
\item \code{"20"}: 1:20 million.
\item \code{"10"}: 1:10 million.
\item \code{"03"}: 1:3 million.
\item \code{"01"}: 1:1 million.
}}
  }}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
Returns
\href{https://en.wikipedia.org/wiki/Autonomous_communities_of_Spain}{Autonomous Communities of Spain} at a
specified scale.
}
\details{
When using \code{ccaa} you can use and mix names and NUTS codes (levels 1 or 2),
ISO codes (corresponding to level 2) or \code{codauto} (see \link{esp_codelist}).
Ceuta and Melilla are considered as Autonomous Communities in this function.

When calling a NUTS1 level, all the Autonomous Communities of that level
will be added.
}
\section{Note}{

Please check the download and usage provisions on \code{\link[giscoR:gisco_attributions]{gisco_attributions()}}.

}

\examples{
ccaa <- esp_get_ccaa()

library(ggplot2)

ggplot(ccaa) +
  geom_sf()

# Random CCAA
random_ccaa <- esp_get_ccaa(ccaa = c(
  "Euskadi",
  "Catalunya",
  "ES-EX",
  "Canarias",
  "ES52",
  "01"
))


ggplot(random_ccaa) +
  geom_sf(aes(fill = codauto), show.legend = FALSE) +
  geom_sf_label(aes(label = codauto), alpha = 0.3) +
  coord_sf(crs = 3857)

# All CCAA of a Zone plus an addition

mixed <- esp_get_ccaa(ccaa = c("La Rioja", "Noroeste"))

ggplot(mixed) +
  geom_sf()

# Combine with giscoR to get countries
\donttest{

library(giscoR)
library(sf)

res <- 20 # Set same resoluion

europe <- gisco_get_countries(resolution = res)
ccaa <- esp_get_ccaa(moveCAN = FALSE, resolution = res)


ggplot(europe) +
  geom_sf(fill = "#DFDFDF", color = "#656565") +
  geom_sf(data = ccaa, fill = "#FDFBEA", color = "#656565") +
  coord_sf(
    xlim = c(23, 74) * 10e4,
    ylim = c(14, 55) * 10e4,
    crs = 3035
  ) +
  theme(panel.background = element_rect(fill = "#C7E7FB"))
}
}
\seealso{
Other datasets representing political borders:
\code{\link{esp_get_capimun}()},
\code{\link{esp_get_ccaa_siane}()},
\code{\link{esp_get_comarca}()},
\code{\link{esp_get_countries_siane}()},
\code{\link{esp_get_gridmap}},
\code{\link{esp_get_munic}()},
\code{\link{esp_get_munic_siane}()},
\code{\link{esp_get_nuts}()},
\code{\link{esp_get_prov}()},
\code{\link{esp_get_prov_siane}()},
\code{\link{esp_get_simpl}},
\code{\link{esp_get_spain}()},
\code{\link{esp_get_spain_siane}()},
\code{\link{esp_siane_bulk_download}()}

Datasets provided by GISCO:
\code{\link{esp_get_munic}()},
\code{\link{esp_get_nuts}()},
\code{\link{esp_get_prov}()},
\code{\link{esp_get_spain}()}
}
\concept{gisco}
\concept{political}
