% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{ison_emotions}
\alias{ison_emotions}
\title{One-mode, weighted network of emotional transitions (Trampe et al. 2015)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> -- # Emotional transitions -----------------------------------------------------
#> # A labelled, complex, weighted, directed network of 18 emotions and 315
#> transition arcs
#> 
#> -- Nodes
#> # A tibble: 18 x 1
#>   name     
#>   <chr>    
#> 1 Alertness
#> 2 Amusement
#> 3 Anger    
#> 4 Anxiety  
#> 5 Awe      
#> 6 Disdain  
#> # i 12 more rows
#> 
#> -- Ties
#> # A tibble: 315 x 3
#>    from    to weight
#>   <int> <int>  <int>
#> 1     1     1   6191
#> 2     1     2     97
#> 3     1     3    214
#> 4     1     4   4784
#> 5     1     5     14
#> 6     1     6     82
#> # i 309 more rows
#> 
}\if{html}{\out{</div>}}
}
\usage{
data(ison_emotions)
}
\description{
Emotions are highly interconnected, and one emotion often follows another.
This network describes the transitions between 18 different emotions as
experienced in everyday life.
The data is collected from 11,000 participants who completed daily
questionnaires on the emotions they felt at a given moment.
While Trampe et al. (2015) created and analysed an undirected network
in their paper, the directed network constructed by Will Hipson
is shared here.
}
\references{
Trampe, Debra, Jordi Quoidbach, and Maxime Taquet. 2015.
"Emotions in everyday life".
\emph{PLOS ONE}.
\doi{10.1371/journal.pone.0145450}

Hipson, Will. 2019.
https://www.r-bloggers.com/2019/03/network-analysis-of-emotions/
}
\keyword{datasets}
