% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_functions.R
\name{maat}
\alias{maat}
\title{Simulate multi-stage multi-administration adaptive test}
\usage{
maat(
  examinee_list = examinee_list,
  assessment_structure = NULL,
  module_list = NULL,
  config = NULL,
  cut_scores = NULL,
  overlap_control_policy = NULL,
  transition_policy = "CI",
  combine_policy = "conditional",
  transition_CI_alpha = NULL,
  transition_percentile_lower = NULL,
  transition_percentile_upper = NULL,
  initial_theta_list = NULL,
  prior_mean_policy = "mean_difficulty",
  prior_mean_user = NULL,
  prior_sd = 1,
  verbose = TRUE
)
}
\arguments{
\item{examinee_list}{an examinee list from \code{\link{simExaminees}}.}

\item{assessment_structure}{a \code{\linkS4class{assessment_structure}} object.}

\item{module_list}{a module list from \code{\link{loadModules}}.}

\item{config}{a \code{\link[TestDesign:config_Shadow-class]{config_Shadow}} object. Also accepts a list of \code{\link[TestDesign:config_Shadow-class]{config_Shadow}} objects to use separate configurations for each module. Must be from 'TestDesign' 1.3.3 or newer, and its \code{exclude_policy$method} slot must be \code{SOFT}.}

\item{cut_scores}{a named list containing cut scores to be used in each grade. Each element must be named in the form \code{G?}, where \code{?} is a number.}

\item{overlap_control_policy}{overlap control is performed by excluding administered items from being administered again within the same examinee.
\itemize{
\item{\code{all}} performs overlap control at all module positions.
\item{\code{within_test}} performs overlap control only within each test.
\item{\code{none}} does not perform overlap control.
}}

\item{transition_policy}{\itemize{
\item{\code{CI}} uses the confidence interval to perform routing.
\item{\code{pool_difficulty_percentile}} uses item difficulty percentiles of all items in the \code{item_pool} argument to perform routing.
\item{\code{pool_difficulty_percentile_exclude_administered}} uses item difficulty percentiles of all items in the \code{item_pool} argument to perform routing, excluding all previous items administered to the examinee.
\item{\code{on_grade}} does not permit any transition.
\item{} (default = \code{CI})
}}

\item{combine_policy}{\itemize{
  \item{} This is only applied when \code{module_position \%\% 2 == 0} (at Phase 2, which is the end of each test).
  \item{\code{conditional}} uses the combined theta (using items from the previous module combined with the current module), if the examinee was in the same grade in Phases 1 and 2. If the examinee was in different grades in Phases 1 and 2, then the theta estimate from Phase 2 is used.
  \item{\code{always}} uses the combined theta.
  \item{\code{never}} uses the theta estimate from Phase 2.
  \item{} (default = \code{conditional})
}}

\item{transition_CI_alpha}{the alpha level to use when \code{transition_policy == "CI"}.}

\item{transition_percentile_lower}{the percentile value (between 0 and 1) to use for the lower routing when \code{transition_policy == "difficulty_percentile"}.}

\item{transition_percentile_upper}{the percentile value (between 0 and 1) to use for the upper routing when \code{transition_policy == "difficulty_percentile"}.}

\item{initial_theta_list}{(optional) a list containing initial thetas to use in each module position.}

\item{prior_mean_policy}{\itemize{
  \item{} This is only effective at the beginning of each test. This determines what value is used as the prior mean.
  \item{\code{mean_difficulty}} uses the mean item difficulty of the current item pool.
  \item{\code{carryover}} uses the routing theta from the previous module. For Phase 1 of the first test, user supplied values are used if available. Otherwise, the mean item difficulty of the current item pool is used.
  \item{\code{user}} uses user-supplied values in the \code{prior_mean_user} argument.
  \item{} (default = \code{mean_difficulty})
}}

\item{prior_mean_user}{(optional) user-supplied values for the prior mean. Must be a single value, or a vector for each grade.}

\item{prior_sd}{user-supplied values for the prior standard deviation. This is only effective at the beginning of each test. This is utilized regardless of \code{prior_mean_policy}. Must be a single value, or a vector for each grade. (default = \code{1})}

\item{verbose}{if \code{TRUE}, print status messages. (default = \code{TRUE})}
}
\value{
an \code{\linkS4class{output_maat}} object from the simulation.
}
\description{
\code{\link{maat}} is the main function for simulating a multi-stage multi-administration adaptive test.
}
\examples{
\donttest{
library(TestDesign) # >= 1.3.3
config <- createShadowTestConfig(
  final_theta = list(method = "MLE"),
  exclude_policy = list(method = "SOFT", M = 100)
)
# exclude_policy must be SOFT

examinee_list <- maat(
  examinee_list          = examinee_list_math,
  assessment_structure   = assessment_structure_math,
  module_list            = module_list_math,
  overlap_control_policy = "all",
  transition_CI_alpha    = 0.05,
  config                 = config,
  cut_scores             = cut_scores_math
)
}
}
