% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{prepare_data}
\alias{prepare_data}
\title{Prepares a dataframe for the analysis}
\usage{
prepare_data(
  data,
  reference_month,
  reference_year,
  usual_weekly_hours,
  female_spec = "F",
  male_spec = "M",
  age_spec = NULL,
  entry_date_spec = NULL
)
}
\arguments{
\item{data}{a dataframe object as produced by \code{read_data} which is to
be used in the analysis}

\item{reference_month}{a number indicating the reference month of the
analysis}

\item{reference_year}{a number indicating the reference year of the analysis}

\item{usual_weekly_hours}{an optional numeric representing the usual weekly
working hours}

\item{female_spec}{a string or number indicating the way females are
specified in the dataset}

\item{male_spec}{a string or number indicating the way males are
specified in the dataset}

\item{age_spec}{a string indicating the age specification, can be one of
\code{NULL}, \code{"age"}, \code{"birthyear"}, or \code{"date_of_birth"}. If
this parameter is set to \code{NULL}, the function automatically tries to
infers the specification}

\item{entry_date_spec}{a string indicating the entry_date specification, can
be one of \code{NULL}, \code{"years"}, \code{"entry_year"}, or
\code{"entry_date"}. If this parameter is set to \code{NULL}, the function
automatically tries to infers the specification}
}
\value{
a data.frame which has no incorrect rows left and can be used to
estimate the standard analysis model
}
\description{
Prepares a dataframe for the analysis in three steps:
\itemize{
\item{Checks whether \code{sex}, \code{age}, and \code{entry_date} have the
correct format and whether their specifications are plausible}
\item{Build the dataframe used for the analysis}
\item{Check each row of the dataframe for correctness and plausibility}
}
}
\keyword{internal}
