% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{data}
\name{all_undesirable_functions}
\alias{all_undesirable_functions}
\alias{default_undesirable_functions}
\alias{all_undesirable_operators}
\alias{default_undesirable_operators}
\title{Default undesirable functions and operators}
\format{
A named list of character strings.
}
\usage{
all_undesirable_functions

default_undesirable_functions

all_undesirable_operators

default_undesirable_operators
}
\description{
Lists of function names and operators for \code{\link[=undesirable_function_linter]{undesirable_function_linter()}} and \code{\link[=undesirable_operator_linter]{undesirable_operator_linter()}}.
There is a list for the default elements and another that contains all available elements.
Use \code{\link[=modify_defaults]{modify_defaults()}} to produce a custom list.
}
\keyword{datasets}
\details{
The following functions are sometimes regarded as undesirable:
\itemize{
\item \code{\link[=.libPaths]{.libPaths()}} As an alternative, use \code{\link[withr:with_libpaths]{withr::with_libpaths()}} for a temporary change instead of permanently modifying the library location.
\item \code{\link[=attach]{attach()}} As an alternative, use roxygen2's @importFrom statement in packages, or \code{::} in scripts. \code{\link[=attach]{attach()}} modifies the global search path.
\item \code{\link[=browser]{browser()}} As an alternative, remove this likely leftover from debugging. It pauses execution when run.
\item \code{\link[=debug]{debug()}} As an alternative, remove this likely leftover from debugging. It traps a function and causes execution to pause when that function is run.
\item \code{\link[=debugcall]{debugcall()}} As an alternative, remove this likely leftover from debugging. It traps a function and causes execution to pause when that function is run.
\item \code{\link[=debugonce]{debugonce()}} As an alternative, remove this likely leftover from debugging. It traps a function and causes execution to pause when that function is run.
\item \code{\link[=detach]{detach()}} As an alternative, avoid modifying the global search path. Detaching environments from the search path is rarely necessary in production code.
\item \code{\link[=library]{library()}} As an alternative, use roxygen2's @importFrom statement in packages and \code{::} in scripts, instead of modifying the global search path.
\item \code{\link[=mapply]{mapply()}} As an alternative, use \code{\link[=Map]{Map()}} to guarantee a list is returned and simplify accordingly.
\item \code{\link[=options]{options()}} As an alternative, use \code{\link[withr:with_options]{withr::with_options()}} for a temporary change instead of permanently modifying the session options.
\item \code{\link[=par]{par()}} As an alternative, use \code{\link[withr:with_par]{withr::with_par()}} for a temporary change instead of permanently modifying the graphics device parameters.
\item \code{\link[=require]{require()}} As an alternative, use roxygen2's @importFrom statement in packages and \code{\link[=library]{library()}} or \code{::} in scripts, instead of modifying the global search path.
\item \code{\link[=sapply]{sapply()}} As an alternative, use \code{\link[=vapply]{vapply()}} with an appropriate \code{FUN.VALUE=} argument to obtain type-stable simplification.
\item \code{\link[=setwd]{setwd()}} As an alternative, use \code{\link[withr:with_dir]{withr::with_dir()}} for a temporary change instead of modifying the global working directory.
\item \code{\link[=sink]{sink()}} As an alternative, use \code{\link[withr:with_sink]{withr::with_sink()}} for a temporary redirection instead of permanently redirecting output.
\item \code{\link[=source]{source()}} As an alternative, manage dependencies through packages. \code{\link[=source]{source()}} loads code into the global environment unless \code{local = TRUE} is used, which can cause hard-to-predict behavior.
\item \code{\link[=structure]{structure()}} As an alternative, Use \code{class<-}, \code{names<-}, and \code{attr<-} to set attributes.
\item \code{\link[=Sys.setenv]{Sys.setenv()}} As an alternative, use \code{\link[withr:with_envvar]{withr::with_envvar()}} for a temporary change instead of permanently modifying global environment variables.
\item \code{\link[=Sys.setlocale]{Sys.setlocale()}} As an alternative, use \code{\link[withr:with_locale]{withr::with_locale()}} for a temporary change instead of permanently modifying the session locale.
\item \code{\link[=trace]{trace()}} As an alternative, remove this likely leftover from debugging. It traps a function and causes execution of arbitrary code when that function is run.
\item \code{\link[=undebug]{undebug()}} As an alternative, remove this likely leftover from debugging. It is only useful for interactive debugging with \code{\link[=debug]{debug()}}.
\item \code{\link[=untrace]{untrace()}} As an alternative, remove this likely leftover from debugging. It is only useful for interactive debugging with \code{\link[=trace]{trace()}}.
}

The following operators are sometimes regarded as undesirable:
\itemize{
\item \code{\link[base:assignOps]{->>}}. It assigns outside the current environment in a way that can be hard to reason about. Prefer fully-encapsulated functions wherever possible, or, if necessary, assign to a specific environment with \code{\link[=assign]{assign()}}. Recall that you can create an environment at the desired scope with \code{\link[=new.env]{new.env()}}.
\item \code{\link[base:ns-dblcolon]{:::}}. It accesses non-exported functions inside packages. Code relying on these is likely to break in future versions of the package because the functions are not part of the public interface and may be changed or removed by the maintainers without notice. Use public functions via \code{::} instead.
\item \code{\link[base:assignOps]{<<-}}. It assigns outside the current environment in a way that can be hard to reason about. Prefer fully-encapsulated functions wherever possible, or, if necessary, assign to a specific environment with \code{\link[=assign]{assign()}}. Recall that you can create an environment at the desired scope with \code{\link[=new.env]{new.env()}}.
}
}
