% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gamma.R
\name{get_gamma}
\alias{get_gamma}
\title{Calculate gamma}
\usage{
get_gamma(from, to, f, alpha = 0.05)
}
\arguments{
\item{from}{A vector of infectors.}

\item{to}{A vector of infectees.}

\item{f}{A named numeric value representing the prevalence of each group in the population or directly the group sizes.}

\item{alpha}{The significance level for the confidence interval.}
}
\value{
A data frame with the estimated gamma, lower and upper confidence limits for each group.
}
\description{
Computes the tansmission assortativity coefficient defined as the excess probability of a secondary infection taking place within-group compared to random expectations.
}
\examples{
from <- c("A", "A", NA, "C", "C", "C")
to <- c("A", "B", "B", "C", "C", "C")
f <- c(A = 0.3, B = 0.2, C = 0.5)
get_gamma(from, to, f, alpha = 0.05)
}
