% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-out.R
\name{noise_sor}
\alias{noise_sor}
\alias{sor}
\title{Noise Segmentation Algorithm}
\usage{
sor(k = 10, m = 3, quantile = FALSE)
}
\arguments{
\item{k}{numeric. The number of neighbours}

\item{m}{numeric. Multiplier. The maximum distance will be: \verb{avg distance + m * std deviation}.
If \code{quantile = TRUE}, \code{m} becomes the quantile threshold.}

\item{quantile}{boolean. Modification of the original SOR to use a quantile
threshold instead of a standard deviation multiplier. In this case the maximum
distance will be: \code{quantile(distances, probs = m)}}
}
\description{
This function is made to be used in \link{classify_noise}. It implements an
algorithm for outliers (noise) segmentation based on Statistical Outliers
Removal (SOR) methods first described in the PCL library
and also implemented in CloudCompare (see references).
For each point, it computes the mean distance to all its k-nearest neighbours.
The points that are farther than the average distance plus a number of times
(multiplier) the standard deviation are considered noise.
}
\examples{
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
las <- readLAS(LASfile, filter = "-inside 273450 5274350 273550 5274450")

# Add some artificial outliers because the original
# dataset is 'clean'
set.seed(314)
id = round(runif(20, 0, npoints(las)))
set.seed(42)
err = runif(20, -50, 50)
las$Z[id] = las$Z[id] + err

las <- classify_noise(las, sor(15,7))
}
\references{
https://pointclouds.org/documentation/tutorials/statistical_outlier.html \cr
https://www.cloudcompare.org/doc/wiki/index.php?title=SOR_filter
}
\seealso{
Other noise segmentation algorithms: 
\code{\link{noise_ivf}}
}
\concept{noise segmentation algorithms}
